#pragma once

#include <passport/infra/daemons/blackbox/src/grants/consumer.h>

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TAttributesSettings;
    class TDbFetcher;
    class TDbProfile;
    class TExtAttrsChunk;
    class TGrantsChecker;

    class TPhoneAttrsHelper {
    public:
        TPhoneAttrsHelper(TDbFetcher& fetcher, const NCommon::TRequest& req);

        static void CheckGrants(TConsumer::ERank rank,
                                const TAttributesSettings& settings,
                                TGrantsChecker& checker);

        std::unique_ptr<TExtAttrsChunk> Result(const TDbProfile* profile) const;

    private:
        enum class EMode {
            ModeAll,
            ModeBound
        };

        EMode Mode_;
        std::vector<TString> Attrs_;
    };

}
