#pragma once

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NAuth {
    class TPublicIdEncryptor;
}

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TDbFetcher;
    class TDbProfile;

    class TPublicIdHelper {
    public:
        TPublicIdHelper(TDbFetcher& fetcher,
                        const NCommon::TRequest& request,
                        const NAuth::TPublicIdEncryptor* encryptor);

        std::unique_ptr<TString> Result(const TDbProfile* profile) const;

    private:
        int Version_ = -1;
        int PublicIdAlias_ = -1;
        int UserDefinedPublicId_ = -1;
        const NAuth::TPublicIdEncryptor* Encryptor_;
    };
}
