#include "strong_pwd_helper.h"

#include <passport/infra/daemons/blackbox/src/misc/db_fetcher.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>

namespace NPassport::NBb {
    // SOX: к запрашиваемым из базы полям добавляем данные о подписке на строгую парольную политику
    // и время последней смены пароля
    TStrongPwdHelper::TStrongPwdHelper(TDbFetcher& fetcher) {
        Suid_ = fetcher.AddAttr(TAttr::ACCOUNT_STRONG_PASSWORD_REQUIRED);
        PwdTime_ = fetcher.AddAttr(TAttr::PASSWORD_UPDATE_DATETIME);
        TwoFaOn_ = fetcher.AddAttr(TAttr::ACCOUNT_2FA_ON);
    }

    // SOX: возвращаем время последней смены пароля
    time_t TStrongPwdHelper::PasswdTime(const TDbProfile* profile) const {
        if (!profile) {
            return 0;
        }
        return profile->Get(PwdTime_)->AsTime();
    }

    // SOX: проверяем, не превышен ли срок действия пароля
    bool TStrongPwdHelper::PasswdExpired(const TDbProfile* profile, unsigned expireTime) const {
        if (expireTime == 0 || !profile                       // if check is turned off or account not found
            || profile->Get(TwoFaOn_)->Value == TStrings::ONE // or 2FA on (and password not used and does not expire)
            || !profile->Get(Suid_)->AsBoolean()) {           // no strong password policy required
            return false;
        }
        return (time(nullptr) - PasswdTime(profile)) > expireTime;
    }
}
