#pragma once

#include <time.h>

namespace NPassport::NBb {
    class TDbFetcher;
    class TDbProfile;

    // SOX: вспомогательный класс для проверки состояния строгой парольной политики
    // при создании объекта он добавляет нужные поля в список запрашиваемых из базы
    // после обращения к базе методы IsStrong и PasswdTime возвращают включена ли у
    // пользователя строгая политика и время последней смены пароля соответственно

    // Helper class to check if user has strong password policy
    class TStrongPwdHelper {
    public:
        TStrongPwdHelper(TDbFetcher& fetcher);
        time_t PasswdTime(const TDbProfile* profile) const;
        bool PasswdExpired(const TDbProfile* profile, unsigned expireTime) const;

    private:
        int Suid_;
        int PwdTime_;
        int TwoFaOn_;
    };
}
