#include "uid_helper.h"

#include <passport/infra/daemons/blackbox/src/domain/domain.h>
#include <passport/infra/daemons/blackbox/src/misc/db_profile.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/output/uid_chunk.h>

namespace NPassport::NBb {
    std::unique_ptr<TUidChunk> TUidHelper::Result(const TDbProfile* profile,
                                                  bool lite,
                                                  const TDomain& pddDomain) {
        std::unique_ptr<TUidChunk> uidChunk = std::make_unique<TUidChunk>();

        if (pddDomain.IsFound()) {
            uidChunk->Domain = pddDomain.AsciiName();
            uidChunk->DomainId = pddDomain.Id();
            uidChunk->Mx = pddDomain.Mx();
            uidChunk->DomainEna = pddDomain.Ena();
            if (profile) {
                uidChunk->CatchAll = profile->CatchAll();
            }
        }

        if (nullptr == profile) {
            // if there is NO account - we don't know is it PDD or not
            // so for backward compatibility we assume hosted=true if domain found
            uidChunk->Hosted = pddDomain.IsFound();
            return uidChunk;
        }
        uidChunk->Lite = lite;
        uidChunk->Uid = profile->Uid();
        uidChunk->Hosted = profile->Pdd();

        return uidChunk;
    }

}
