#pragma once

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TDbFetcher;
    class TDbProfile;
    class TExtAttrsChunk;
    class TGrantsChecker;

    class TWebauthnAttrsHelper {
    public:
        TWebauthnAttrsHelper(TDbFetcher& fetcher, const NCommon::TRequest& req);

        static void CheckGrants(TGrantsChecker& checker);

        std::unique_ptr<TExtAttrsChunk> Result(const TDbProfile* profile) const;

    private:
        std::vector<TString> Attrs_;
    };

}
