#pragma once

#include "ipacl_map.h"

namespace NPassport::NBb {

    template <typename T>
    class TIpAcl {
    public:
        TIpAcl(const TString& aclHeader, const TString& entryHeader)
            : AclHeader_(aclHeader)
            , EntryHeader_(entryHeader)
        {
        }
        virtual ~TIpAcl<T>() = default;

        // Return a Peer or nullptr
        std::shared_ptr<T> Find(const NUtils::TIpAddr& ip, typename TIpAclMap<T>::EStorage* storage = nullptr) const {
            std::shared_ptr<TIpAclMap<T>> aclLoc = Acl();
            if (!aclLoc) {
                return std::shared_ptr<T>();
            }
            return aclLoc->Find(ip, storage);
        }

        void Print() const {
            std::shared_ptr<TIpAclMap<T>> aclLoc = Acl();
            if (aclLoc) {
                aclLoc->Print(AclHeader_, EntryHeader_, [this](const T& p) { return PrintEntryInfo(p); });
            }
        }

        void SetAcl(std::shared_ptr<TIpAclMap<T>> aclMap) {
            std::atomic_store(&IpAclMap_, aclMap);
        }

    protected:
        std::shared_ptr<TIpAclMap<T>> Acl() const {
            return std::atomic_load(&IpAclMap_);
        }

        virtual TString PrintEntryInfo(const T&) const {
            return {};
        }

    protected:
        std::shared_ptr<TIpAclMap<T>> IpAclMap_;
        const TString AclHeader_;
        const TString EntryHeader_;
    };
}
