#include "ipacl_loader.h"

#include <util/datetime/base.h>

namespace NPassport::NBb {
    TIpAclLoader::TIpAclLoader(const TString& path,
                               const TString& aclHeader,
                               const TString& entryHeader)
        : TIpAcl(aclHeader, entryHeader)
        , Path_(path)
    {
    }

    time_t TIpAclLoader::GetMTime() const {
        std::shared_ptr<TIpAclMap<TConsumer>> cache = Acl();
        return cache ? cache->GetMTime() : 0;
    }

    void TIpAclLoader::Update(const TStringBuf fileBody, const time_t mtime) {
        // It is ok to copy shared_ptr without syncronization - can be modified only in this thread
        std::shared_ptr<TIpAclMap<TConsumer>> current = IpAclMap_;

        SetAcl(Parse(fileBody, mtime));

        // AclMap is a huge object. It is very expensive to destroy it
        // Much better to perform destruction in this thread than in worker
        while (current.use_count() > 1) {
            std::this_thread::sleep_for(std::chrono::milliseconds(500));
        }

        Print();
    }

    void TIpAclLoader::Init(TDuration period) {
        if (period != TDuration()) {
            FileLoader_ = std::make_unique<NUtils::TFileLoader>(
                Path_,
                [this](const TStringBuf fileBody, const time_t mtime) { this->Update(fileBody, mtime); },
                period);
        }
    }
}
