#pragma once

#include "ipacl.h"

#include <passport/infra/libs/cpp/utils/file.h>

namespace NPassport::NBb {
    class TConsumer;

    class TIpAclLoader: public TIpAcl<TConsumer> {
    public:
        TIpAclLoader(const TString& path,
                     const TString& aclHeader,
                     const TString& entryHeader);

        time_t GetMTime() const;

    protected:
        void Init(TDuration period);

        void Update(const TStringBuf fileBody, const time_t mtime);
        virtual std::shared_ptr<TIpAclMap<TConsumer>> Parse(const TStringBuf fileBody, const time_t mtime) = 0;

    protected:
        const TString Path_;

        // must be last member
        std::unique_ptr<NUtils::TFileLoader> FileLoader_;
    };
}
