#include "ipacl_utils.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBb {

    void TIpAclUtils::SkipSpace(TStringBuf& s) {
        while (s && isspace(s[0])) {
            s.Skip(1);
        }
    }

    void TIpAclUtils::SkipNonSpace(TStringBuf& s) {
        auto it = std::find_if(s.begin(), s.end(), isspace);
        if (it != s.end()) {
            s.Trunc(it - s.begin());
        }
    }

    TString TIpAclUtils::Errmsg(TStringBuf s) {
        return NUtils::CreateStr("bad IP range syntax '", s, '\'');
    }

    TString TIpAclUtils::RangeMessage(const NUtils::TIpAddr& ipstart,
                                      const NUtils::TIpAddr& ipend,
                                      const TString& oldRule,
                                      const TString& newRule,
                                      bool override) {
        TStringStream fmt;
        fmt << "Warning: IP range " << ipstart << "-" << ipend;
        fmt << " already has rule: '" << oldRule << "'. ";
        if (override) {
            fmt << "Overriding this range with more specific rule '" << newRule << "'";
        } else {
            fmt << "Rule '" << newRule << "' is ignored for this range as less specific";
        }

        return fmt.Str();
    }
}
