#include "ipacl_white_list.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>

namespace NPassport::NBb {
    TIpAclWhitelist::TIpAclWhitelist()
        : TIpAcl("BlackBox: Badauth whitelist:", "BlackBox: whitelisted network:")
    {
        IpAclMap_ = std::make_shared<TIpAclMap<TConsumer>>();
    }

    void TIpAclWhitelist::AddEntry(const TString& entry, const TString& name) {
        std::shared_ptr<TConsumer> consumer = std::make_shared<TConsumer>();
        consumer->SetName(name);
        IpAclMap_->ParseAndAddEntry(entry, consumer);
    }

    TString TIpAclWhitelist::PrintEntryInfo(const TConsumer& consumer) const {
        return NUtils::CreateStr(" : '", consumer.GetName(), '\'');
    }

}
