#pragma once

#include "ipacl.h"

#include <passport/infra/libs/cpp/json/reader.h>

#include <library/cpp/string_utils/ztstrbuf/ztstrbuf.h>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    struct TNetworkDescription;
    enum class ENetworkKind;

    // Usernets configuration with several network kinds
    class TUsernetsList {
    public:
        TUsernetsList(const TString& jsonBody);

        ENetworkKind FindNetwork(const NUtils::TIpAddr& ip,
                                 const NCommon::TRequest& req,
                                 const TStringBuf description = {}) const;

    private:
        struct TNetData {
            TString Ip;
            std::shared_ptr<TNetworkDescription> Description;
        };

        static void BuildIpAclEntity(const rapidjson::Document& doc,
                                     TIpAcl<TNetworkDescription>& nets,
                                     const TZtStringBuf& usernetsListType);

        static TNetData UnpackJsonParameters(const rapidjson::Value& jsonIpDescription,
                                             const TStringBuf& name);

        static void LogExperiment(const NUtils::TIpAddr& ip,
                                  const NCommon::TRequest& req,
                                  const TStringBuf description,
                                  const TStringBuf branch,
                                  const TStringBuf ipset,
                                  const TStringBuf macroName);

    protected:
        TIpAcl<TNetworkDescription> InternalExplicit_;
        TIpAcl<TNetworkDescription> RobotExplicit_;
        TIpAcl<TNetworkDescription> Allow_;
        TIpAcl<TNetworkDescription> Deny_;
        TIpAcl<TNetworkDescription> Robots_;
    };
}
