#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <map>
#include <memory>

namespace NPassport::NUtils {
    class ILogger;
}

namespace NPassport::NBb {
    class TAuthLog {
    public:
        enum EFlag {
            OK = 1,
            BAD = 2,
            DISABLED = 3,
            CAPTCHA = 4,
            BLOCKED = 5,
            NEWSESS = 6,
            UPDATESESS = 7,
            BRUTEFORCE = 8,
            SECONDSTEP = 9
        };

        TAuthLog(std::unique_ptr<NUtils::ILogger> logger, const TString& hostid);
        ~TAuthLog();

        void Write(
            const TString& uid,
            const TString& login,
            const TString& sid,
            const TString& authType,
            EFlag flag,
            const TString& comment,
            const TString& attribs,
            bool captchaEntered,
            const TString& userIP,
            const TString& origIP,
            const TString& yandexuid,
            const TString& referer,
            const TString& retpath,
            const TString& useragent) const;

    protected:
        static TString& FormatTimestamp(TString& out, TInstant now = TInstant::Now());

    private:
        const std::unique_ptr<NUtils::ILogger> Logger_;
        const TString Hostid_;
        static const std::map<int, TString> flags_;
    };

}
