#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NUtils {
    class ILogger;
}

namespace NPassport::NBb {
    class TTskvLog {
    public:
        explicit TTskvLog(std::unique_ptr<NUtils::ILogger> logger);

        void LogBadauthBan(const TStringBuf login,
                           const TStringBuf uid,
                           const TStringBuf yandexuid,
                           const TStringBuf rule,
                           const TStringBuf count,
                           const TStringBuf ip,
                           bool show_captcha,
                           bool halfIp = false) const;

        void LogDeadSession(const TStringBuf uid,
                            const TStringBuf authid,
                            long int time_delta) const;

        void LogOAuth(const TStringBuf tokenId,
                      bool byAlias,
                      const TStringBuf status,
                      const TStringBuf uid,
                      const TStringBuf clientId,
                      const TStringBuf scopes,
                      const TStringBuf createTime,
                      const TStringBuf issueTime,
                      const TStringBuf expireTime,
                      const TStringBuf userIp,
                      const TStringBuf deviceId,
                      const TStringBuf deviceName,
                      bool needsRefresh,
                      const TStringBuf reason,
                      const TStringBuf consumer,
                      const TStringBuf consumerIp) const;

        void LogSesCheck(const TStringBuf uids,
                         const TStringBuf defaultUid,
                         const TStringBuf host,
                         const TStringBuf authid,
                         const TStringBuf idnt,
                         const TStringBuf yandexuid,
                         const TStringBuf userip,
                         const TStringBuf userport,
                         const TStringBuf consumer,
                         const TStringBuf consumerIp,
                         const ui32 consumerTvmId) const;

    private:
        const std::unique_ptr<NUtils::ILogger> Logger_;
    };
}
