#pragma once

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TCheckDeviceSignatureResult;
    class TGrantsChecker;
    class TSigner;

    class TCheckDeviceSignatureProcessor {
    public:
        TCheckDeviceSignatureProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TCheckDeviceSignatureResult> Process(const TConsumer& consumer);

        static const TString CDS_STATUS_OK;
        static const TString CDS_STATUS_NONCE_EXPIRED;
        static const TString CDS_STATUS_NONCE_NO_KEY;
        static const TString CDS_STATUS_NONCE_INVALID;
        static const TString CDS_STATUS_DEVICE_ID_INVALID;
        static const TString CDS_STATUS_PUBLIC_KEY_UNSUPPORTED_VERSION;
        static const TString CDS_STATUS_PUBLIC_KEY_NOT_FOUND;
        static const TString CDS_STATUS_PUBLIC_KEY_INVALID;
        static const TString CDS_STATUS_SIGNATURE_INVALID;

    private:
        static std::unique_ptr<TCheckDeviceSignatureResult> CdsCheckNonce(
            const TSigner& signer,
            const TString& nonce,
            const TString& nonceSignSpace,
            const TString& deviceId,
            time_t now);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
