#include "check_sign.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/signer.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/check_sign_result.h>

namespace NPassport::NBb {
    TCheckSignProcessor::TCheckSignProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TCheckSignProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::CheckSign);

        checker.CheckArg(TStrings::SIGN_SPACE, [&](const TString& value) {
            return consumer.IsChecksignAllowed(value);
        });

        return checker;
    }

    std::unique_ptr<TCheckSignResult> TCheckSignProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& signSpace = TUtils::GetCheckedArg(Request_, TStrings::SIGN_SPACE);
        const TString& signedValue = TUtils::GetCheckedArg(Request_, TStrings::SIGNED_VALUE);

        TSigner::TCheckResult result = Blackbox_.Signer().CheckSign(signedValue, signSpace);

        return std::make_unique<TCheckSignResult>(TSigner::StatusStr(result.Status), result.Value);
    }
}
