#include "checkip.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/out_tokens.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>

namespace NPassport::NBb {
    TCheckIpProcessor::TCheckIpProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TCheckIpProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::CheckIp);

        return checker;
    }

    std::unique_ptr<TTypedValueResult> TCheckIpProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& ipAddr = TUtils::GetCheckedArg(Request_, TStrings::IP);
        const TString& nets = TUtils::GetCheckedArg(Request_, TStrings::NETS);
        if (nets != TStrings::YANDEXUSERS) {
            throw TBlackboxError(TBlackboxError::EType::InvalidParams)
                << "Unknown value of " << TStrings::NETS << " argument: " << InvalidValue(nets);
        }

        const bool res = Blackbox_.CheckYandexIp(ipAddr, Request_) == ENetworkKind::Internal;
        return std::make_unique<TTypedValueResult>(TOutTokens::YANDEXIP, res);
    }
}
