#pragma once

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TBlackboxImpl;
    class TCreateOAuthTokenResult;
    class TConsumer;
    class TGrantsChecker;

    class TCreateOAuthTokenProcessor {
    public:
        TCreateOAuthTokenProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TCreateOAuthTokenResult> Process(const TConsumer& consumer);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
