#pragma once

#include "sessionid.h"

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NAuth {
    class TSession;
}

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TDecreaseSessionidLifetimeResult;
    class TGrantsChecker;

    class TDecreaseSessionidLifetimeProcessor: public TSessionProcessorBase {
    public:
        TDecreaseSessionidLifetimeProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TDecreaseSessionidLifetimeResult> Process(const TConsumer& consumer);

    public:
        struct TCheckResult {
            ESessionStatus Status = ESessionStatus::INVALID;
            TString Comment;
            NAuth::TSession Sess;
        };

        TCheckResult CheckSession();
    };
}
