#pragma once

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TTotpProfile;
    class TEditTotpResult;
    class TGrantsChecker;

    class TEditTotpProcessor {
    public:
        TEditTotpProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TEditTotpResult> Process(const TConsumer& consumer);

        static TTotpProfile ReadTotpProfileFromDb(const TBlackboxImpl& blackbox,
                                                  const TString& uid,
                                                  bool junk = false);

    private:
        void AddSecretToResult(TTotpProfile& profile,
                               TEditTotpResult& result,
                               const TString& secret,
                               ui64 secretId,
                               const TString& uidStr,
                               const TString& totpPasswd) const;
        void AddJunkSecret(TTotpProfile& junkProfile,
                           TEditTotpResult& result,
                           const TString& secret,
                           ui64 secretId,
                           const TString& uidStr) const;

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
