#pragma once

#include "sessionid.h"

namespace NPassport::NBb {
    class TCreateSessionResult;
    class TGrantsChecker;

    class TEditSessionProcessor: public TSessionProcessorBase {
    public:
        TEditSessionProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TCreateSessionResult> Process(const TConsumer& consumer);

    private:
        void CheckGrants(const TConsumer& consumer, const TString& uid);
    };
}
