#pragma once

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NPassport::NDbPool {
    class TResult;
}

namespace NPassport::NBb {
    class TBaseResultHelper;
    class TBlackboxImpl;
    class TConsumer;
    class TDbFetcher;
    class TFamilyInfoResult;
    class TGrantsChecker;

    class TFamilyInfoProcessor {
    public:
        enum class EMembersInfo {
            None,
            All,
            Kids,
            Children,
            Adults,
        };

        enum class EFetchStatus {
            Ok,
            NoResult,
            VerifyFailed,
        };

    public:
        TFamilyInfoProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TFamilyInfoResult> Process(const TConsumer& consumer);

    public:
        struct TFetchFamilyParams {
            TString FamilyId;
            bool GetPlace = false;
            EMembersInfo MembersInfo = EMembersInfo::All;
            std::optional<TString> UidFromCred;
        };

        static EFetchStatus FetchFromDb(TDbFetcher& fetcher,
                                        const TFetchFamilyParams& params,
                                        const int isChildIdx,
                                        TString& adminUid,
                                        ui16& kidsCount);

        static EMembersInfo GetMembersInfo(const NCommon::TRequest& request);

        static TString ToInternalFamilyId(const TString& id);
        static TString FromInternalFamilyId(const TStringBuf id);

    private:
        bool CheckUserTicket(std::optional<TString>& uid, TFamilyInfoResult& result);
        static void BuildSimpleResult(TDbFetcher& fetcher,
                                      const bool getPlace,
                                      TFamilyInfoResult& result);
        static bool BuildCommonResult(TDbFetcher& fetcher,
                                      const std::optional<TString>& uidFromCred,
                                      const bool getPlace,
                                      const int isChildIdx,
                                      TBaseResultHelper& baseResultHelper,
                                      TFamilyInfoResult& result);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
