#pragma once

#include <passport/infra/libs/cpp/request/request.h>

#include <set>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TFindByPhoneNumbersResult;
    class TGrantsChecker;

    class TFindByPhoneNumbersProcessor {
    public:
        TFindByPhoneNumbersProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TFindByPhoneNumbersResult> Process(const TConsumer& consumer);

    private:
        using TNumberUidPairs = std::vector<std::pair<TString, TString>>;
        TNumberUidPairs ReadPhoneBindings(const TString& numbersList, std::set<TString>& foundUids);

        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
