#include "generate_public_id.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/out_tokens.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>

#include <passport/infra/libs/cpp/auth_core/public_id.h>
#include <passport/infra/libs/cpp/auth_core/public_id_encryptor.h>

namespace NPassport::NBb {
    TGeneratePublicIdProcessor::TGeneratePublicIdProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TGeneratePublicIdProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::GeneratePublicId);

        return checker;
    }

    std::unique_ptr<TTypedValueResult> TGeneratePublicIdProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& strUid = TUtils::GetUIntArg(Request_, TStrings::UID, true);
        const TString& strVersion = TUtils::GetUIntArg(Request_, TStrings::VERSION);

        ui64 uid = IntFromString<ui64, 10>(strUid);
        ui8 version = strVersion ? IntFromString<ui8, 10>(strVersion) : 0;

        const NAuth::TPublicIdEncryptor* encryptor = Blackbox_.PublicIdEncryptor();
        if (!encryptor) {
            throw TBlackboxError(TBlackboxError::EType::Unknown)
                << "PublicId settings not configured.";
        }

        return std::make_unique<TTypedValueResult>(TOutTokens::PUBLIC_ID, encryptor->Encrypt(NAuth::TPublicId(uid, version)));
    }
}
