#include "get_max_uid.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/output/get_max_uid_result.h>

#include <passport/infra/libs/cpp/dbpool/handle.h>

namespace NPassport::NBb {
    TGetMaxUidProcessor::TGetMaxUidProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TGetMaxUidProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::GetMaxUid);

        return checker;
    }

    static const TString COMMON_QUERY = "SELECT MAX(uid) FROM uid UNION ALL SELECT MAX(uid) FROM pdduid;";
    static const TString YATEAM_QUERY = "SELECT MAX(uid) FROM uid;";

    std::unique_ptr<TGetMaxUidResult> TGetMaxUidProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const bool isYateam = Blackbox_.IsYaTeam();

        NDbPool::TBlockingHandle h(Blackbox_.CentralDb());
        std::unique_ptr<NDbPool::TResult> dbres = h.Query(isYateam ? YATEAM_QUERY : COMMON_QUERY);

        std::unique_ptr res = std::make_unique<TGetMaxUidResult>();

        dbres->Fetch(res->Uid);

        if (!isYateam) {
            ui64 uid = 0;
            dbres->Fetch(uid);
            res->Pdduid = uid;
        }

        return res;
    }
}
