#pragma once

#include <passport/infra/daemons/blackbox/src/oauth/multi_fetcher.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TDbFetcher;
    class TDbProfile;
    class TGetOAuthTokensResult;
    class TGrantsChecker;
    class TOAuthAttrsHelper;
    class TOAuthMultiFetcher;
    class TOAuthTokenInfo;
    class TStrongPwdHelper;

    class TGetOAuthTokensProcessor {
    public:
        TGetOAuthTokensProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);
        ~TGetOAuthTokensProcessor();

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TGetOAuthTokensResult> Process(const TConsumer& consumer);

    public:
        struct TRequestParams {
            std::reference_wrapper<const TString> Uid;
            bool Fullinfo = false;
            bool NeedLoginId = false;

            // filters
            bool XtokenOnly = false;
            std::optional<ui32> ClientId;
            TStringBuf DeviceId;

            static TRequestParams Create(const NCommon::TRequest& request);
        };

        struct TAttrIndexes {
            int Available = -1;
            int Glogout = -1;
            int RevokerTokens = -1;
            int ChangeReason = -1;
            int CreateRequired = -1;
        };

        void AddParamsToFetcher(TDbFetcher& fetcher);

        TOAuthMultiFetcher::TTokens FetchEntriesByUid(
            TDbFetcher& fetcher,
            const TOAuthMultiFetcher& oauthFetcher) const;
        TOAuthMultiFetcher::TTokens FetchClientInfoAndFilterTokens(
            TOAuthMultiFetcher::TTokens tokens,
            const TDbProfile& profile,
            const TOAuthMultiFetcher& oauthFetcher) const;

        TOAuthError UpdateTokenStatus(
            const TDbProfile& profile,
            const TOAuthMultiFetcher::TToken& token) const;

        static TOAuthMultiFetcher::TTokens FilterByXToken(TOAuthMultiFetcher::TTokens tokens);
        static TOAuthMultiFetcher::TTokens FilterByTokenStatus(TOAuthMultiFetcher::TTokens tokens);

        static std::unique_ptr<TGetOAuthTokensResult> BuildResult(const TOAuthAttrsHelper& attrsHelper,
                                                                  TOAuthMultiFetcher::TTokens tokens,
                                                                  bool needLoginId);
        void LogDebugMessage(TStringBuf description) const;

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;

        std::optional<TRequestParams> Params_;
        TAttrIndexes AttrIndexes_;
        std::unique_ptr<TStrongPwdHelper> StrongPwdHelper_;
    };
}
