#include "get_recovery_keys.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/shards_map.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/out_tokens.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>

namespace NPassport::NBb {
    TGetRecoveryKeysProcessor::TGetRecoveryKeysProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TGetRecoveryKeysProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::GetRecoveryKeys);

        return checker;
    }

    static const TString GET_RECOVERY_KEYS_QUERY = "SELECT recovery_key FROM passman_recovery_keys WHERE uid=";
    static const TString KEY_ID_CHECK = " AND BINARY key_id='";

    std::unique_ptr<TTypedValueResult> TGetRecoveryKeysProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& uid = TUtils::GetUIntArg(Request_, TStrings::UID, true);
        TString keyId = NUtils::Base64ToBin(TUtils::GetCheckedArg(Request_, TStrings::KEY_ID));

        NDbPool::TBlockingHandle sqlh(Blackbox_.ShardsMap().GetPool(uid));
        TString query = NUtils::CreateStr(
            GET_RECOVERY_KEYS_QUERY, uid, KEY_ID_CHECK, sqlh.EscapeQueryParam(keyId), "'");

        std::unique_ptr<NDbPool::TResult> res = sqlh.Query(query);

        TString result;

        if (res->Fetch(result)) {
            result = NUtils::BinToBase64(result);
        }

        return std::make_unique<TTypedValueResult>(TOutTokens::RECOVERY_KEY, result);
    }
}
