#pragma once

#include <passport/infra/daemons/blackbox/src/output/table_result.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>
namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TGrantsChecker;

    class THostedDomainsProcessor {
    public:
        THostedDomainsProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TTableResult> Process(const TConsumer& consumer);

    private:
        std::vector<TTableResult::TStringVector> FetchFromDb(const TString& admin,
                                                             const TString& domid,
                                                             const TString& domain,
                                                             bool aliases) const;
        std::vector<TTableResult::TStringVector> FetchFromCache(const TString& admin,
                                                                const TString& domid,
                                                                const TString& domain,
                                                                bool aliases) const;

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
