#include "lcookie.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/lcookie_parser.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/lcookie_result.h>

namespace NPassport::NBb {
    TLCookieProcessor::TLCookieProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TLCookieProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::LCookie);

        return checker;
    }

    std::unique_ptr<TLCookieResult> TLCookieProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& lcookiestr = TUtils::GetCheckedArg(Request_, TStrings::L);

        return TLCookieParser::Parse(lcookiestr, Blackbox_.SessionSigner());
    }
}
