#pragma once

#include <passport/infra/daemons/blackbox/src/domain/domain.h>
#include <passport/infra/daemons/blackbox/src/loggers/authlog.h>
#include <passport/infra/daemons/blackbox/src/misc/login_status.h>
#include <passport/infra/daemons/blackbox/src/misc/login_type.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NBb::NTotp {
    class TService;
}

namespace NPassport::NBb {
    class TBadauthCounts;
    class TBadauthHelper;
    class TBlackboxImpl;
    class TDbFetcher;
    class TDbFieldsConverter;
    class TDbProfile;
    class TDbValue;
    class TLoginResult;
    class TConsumer;
    class TGrantsChecker;

    class TLoginProcessor {
    public:
        TLoginProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TLoginResult> Process(const TConsumer& consumer);

        static TString GetUidLogin(const TString& uid);
        static TString CheckForProxy(const NCommon::TRequest& req);

    private:
        void InitParameters();
        void InitOptionalParams();
        TString GetBadauthLogin() const;
        bool ProcessRestrict(TBadauthHelper& badauth, const TConsumer& consumer, const TString& remoteIp, TLoginStatus& status);
        bool HaveLoginAttempts(TBadauthHelper& badauth, bool canCaptcha);
        void AuthLog(TAuthLog::EFlag status, const TString& comment) const;
        void LoginLog(TAuthLog::EFlag status, const TString& serviceIp) const;
        void BruteforceLog(TBadauthCounts& counts) const;

        struct TFetchLoginStatus {
            using TStatus = TLoginStatus::TStatusPair;
            TStatus Status;
            time_t TotpCheckTime = 0;
            TString Comment;
            TString ConnectionId;
            std::optional<TString> AllowedSecondSteps;
            bool PasswordChangeRequired = false;

            TFetchLoginStatus(const TStatus& status = TLoginStatus::PAIR_BAD_PASSWORD)
                : Status(status)
            {
            }

            TFetchLoginStatus& operator=(const TStatus& v) {
                Status = v;
                return *this;
            }
            const TStatus::first_type& First() const {
                return Status.first;
            }

            void SetFirst(const TStatus::first_type& v) {
                Status.first = v;
            }

            const TStatus::second_type& Second() const {
                return Status.second;
            }
        };

        const TDbProfile* FetchLoginDbFields(TDbFetcher& fetcher, TFetchLoginStatus& status);

        static std::unique_ptr<TLoginResult> GetErrorLogin(const TLoginStatus& status);

        TLoginStatus::TStatusPair CheckPasswordPerimeter(std::optional<TString>& allowedSecondSteps, bool& passwordChangeRequired);

        static time_t LastValidTotpTime(const TDbValue* tm);

        TLoginStatus::TStatusPair YandexTeamCheckPassword(std::optional<TString>& allowedSecondSteps, bool& passwordChangeRequired);
        TLoginStatus::TStatusPair CheckPasswordAsOAuth(time_t glogoutTime,
                                                       time_t revokeAppPasswordTime,
                                                       time_t domainGlogout,
                                                       TString& comment,
                                                       TString& connectionId);
        TLoginStatus::TStatusPair CheckPasswordScholar(const TString& pwdHash);

    private:
        static inline TString PasswordHash(const TStringBuf pwd, const TStringBuf secret);

        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
        TString Uid_;
        TString Sid_;
        std::vector<TString> Sids_;
        TString Login_;
        TString Password_;
        TDomain PddDomain_;
        TString PasswdHash_;
        TString AuthLogin_;
        TString Ssl_;
        TString UserIp_;
        TString ProxyIp_;
        TString Referer_;
        TString Retpath_;
        TString UserAgent_;
        TString YandexUid_;
        TString AuthType_;
        bool CaptchaEntered_ = false;
        ELoginType LoginType_ = ELoginType::Alien;
        bool Mail4Domains_ = false;
        bool ForceSid2_ = false;
        bool HaveLogin_ = false;
        bool ShallRestrict_ = false;
        bool CanResist_ = false;
        bool Whitelisted_ = false;
        TString VerComment_;
        TString AuthlogComment_;
        TString LoginlogComment_;
        bool RestrictSession_ = false;
        bool AllowScholar_ = false;
        bool ScholarSession_ = false;
    };
}
