#pragma once

#include <passport/infra/libs/cpp/dbpool/handle.h>
#include <passport/infra/libs/cpp/request/request.h>

#include <util/generic/string.h>

#include <list>
#include <memory>
#include <set>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TLoginOccupationResult;
    class TLoginOccupationStatus;
    class TConsumer;
    class TGrantsChecker;

    using TLoginOccupationStatusMap = std::map<TString, TLoginOccupationStatus>;

    class TLoginOccupationProcessor {
    public:
        TLoginOccupationProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TLoginOccupationResult> Process(const TConsumer& consumer);

    private:
        using TLoginList = std::list<TString>;
        static TString MakeArgList(const TLoginList& l, NDbPool::TBlockingHandle& sqlh);
        TLoginOccupationStatusMap FindLoginsInDb(const TLoginList& accLogins,
                                                 const TLoginList& mailLogins,
                                                 const TLoginList& synthLogins,
                                                 bool isPdd);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };

}
