#pragma once

#include <util/generic/string.h>

#include <memory>
#include <unordered_set>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TBlackboxImpl;
    class TOAuthResult;
    class TOAuthError;
    class TOAuthStatus;
    class TOAuthTokenInfo;
    class TConsumer;
    class TGrantsChecker;

    class TOAuthProcessor {
    public:
        TOAuthProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TOAuthResult> Process(const TConsumer& consumer);

        struct TOptions {
            TString UserIp;
            TStringBuf UserPort;
            TString ScopesRequested;
            bool GetUserTicket = false;
            bool GetLoginId = false;
            bool FillBaseResult = false;
            bool FillOAuthAttrs = false;
        };
        std::unique_ptr<TOAuthResult> ProcessImpl(const TConsumer& consumer, const TOptions& options);

    private:
        std::unique_ptr<TOAuthResult> GetErrorOAuth(const TOAuthError& error,
                                                    const TOAuthTokenInfo* tokenInfo,
                                                    const TString& statboxMsg);
        bool IsRobotFromExternalNetwork(ui64 uid) const;
        void LogRobotCheck(const TOAuthTokenInfo& tokenInfo, const TConsumer& consumer) const;

    public:
        TString BuildUserTicket(ui64 uid,
                                const TConsumer& consumer,
                                const std::unordered_set<TString>& scopes) const;

    private:
        TString UserIp_;
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
