#pragma once

#include <passport/infra/libs/cpp/request/request.h>

#include <memory>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TPhoneBindingsResult;
    class TGrantsChecker;

    class TPhoneBindingsProcessor {
    public:
        TPhoneBindingsProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TPhoneBindingsResult> Process(const TConsumer& consumer);

    private:
        static TString BuildWhereClause(const TString& numbersStr,
                                        const TString& phoneidsStr,
                                        const TString& boundAfter);
        static TString BuildWhereClauseWithNumbers(const TString& numbersStr);
        static TString BuildWhereClauseWithPhoneids(const TString& phoneidsStr);
        TString BuildQuery(const TString& whereClause,
                           bool needCurrent,
                           bool needUnbound,
                           bool needHistory) const;

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
