#pragma once

#include <passport/infra/libs/cpp/request/request.h>

namespace NPassport::NBb {
    class TBlackboxImpl;
    class TConsumer;
    class TPwdHistoryResult;
    class TGrantsChecker;

    class TPwdHistoryProcessor {
    public:
        TPwdHistoryProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TPwdHistoryResult> Process(const TConsumer& consumer);

    private:
        static TString BuildQuery(const TString& uid, const TString& reason, const TString& depth);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };
}
