#pragma once

#include <passport/infra/libs/cpp/auth_core/sessguard.h>
#include <passport/infra/libs/cpp/auth_core/session.h>
#include <passport/infra/libs/cpp/auth_core/sessionparser.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TAuthChunk;
    class TAuthIdChunk;
    class TBlackboxImpl;
    class TCreateSessionResult;
    class TIpComparator;
    class TNewSessionChunk;
    class TResignedCookiesChunk;
    class TSessguardChunk;
    class TSessionResult;
    class TConsumer;
    class TGrantsChecker;

    class TSessionProcessorBase {
    public:
        enum class ESessionStatus: int {
            VALID,      // valid, all data present
            NEED_RESET, // valid, all data present, need resetting
            EXPIRED,    // invalid, no data, shall prompt for login
            NOAUTH,     // invalid, no data, should not ask again until aged
            DISABLED,   // invalid, no data, account is disabled
            INVALID,    // invalid, all other cases (sign broken, garbage, etc.)

            DEPRECATED_1, // to save enum No.
            DEPRECATED_2,
            WRONG_GUARD,
        };

    public:
        TSessionProcessorBase(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        NAuth::TSession CheckCookieAndRestrictions(ESessionStatus& status,
                                                   std::unique_ptr<TAuthIdChunk>& authidChunk,
                                                   TString& comment,
                                                   std::vector<TString>& uidsList);
        bool IsSessionKilled(const NAuth::TSession& sess, const TString& authid) const;

        std::unique_ptr<TAuthIdChunk> ParseAuthId(TString& authid) const;
        std::unique_ptr<TAuthIdChunk> ParseAuthId(NAuth::TSession& session) const;

        std::vector<TStringBuf> GetGuardHostsArg() const;

        bool HasAnotherGuardHost(const std::vector<TStringBuf>& guardHosts,
                                 const TString& hostGuardspace,
                                 const TString& domain) const;
        std::unique_ptr<TSessguardChunk> GetSessguardCookies(const std::vector<TStringBuf>& guardHosts,
                                                             const TString& authid,
                                                             const TString& domain,
                                                             time_t createTime = std::time(nullptr),
                                                             bool deleteGuards = false) const;

        ESessionStatus CheckUserStatus(NAuth::TSession& sess,
                                       int idx,
                                       ESessionStatus status,
                                       bool available,
                                       time_t glogout,
                                       time_t revokeWebSessions,
                                       time_t domainGlogout,
                                       bool changeReason,
                                       bool createRequired,
                                       bool passwdExpired,
                                       TString& comment,
                                       bool& haveExternal) const;

        // only for method=sessionid and method=editsession
        NAuth::TSessGuard CheckSessGuard(const TString& guardStr,
                                         const TString& authId,
                                         const TString& consumerName) const;

        void GetSessionidFromArgs();

    protected:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;

        // input args
        TString UserIp_;
        TString SessionId_;
        TString Host_;

        TStringBuf LogableSessionId_;

        // for checkCookieAndRestrictions
        bool UserIpIsYandex_ = false;
        bool ExtUserIpMatch_ = false;
        bool ExtSessionExpired_ = false;

    private:
        mutable NDbPool::TNonBlockingHandle SesskillSqlh_;
    };

    class TSessionidProcessor: public TSessionProcessorBase {
    public:
        static const TString SCOPE_BB_SESSIONID;
        static const TString SCOPE_BB_SESSGUARD;

        TSessionidProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TSessionResult> Process(const TConsumer& consumer);

    private:
        std::unique_ptr<TSessionResult> GetErrorSessionId(ESessionStatus status,
                                                          NAuth::TSession& sess,
                                                          const TString& comment) const;
        std::unique_ptr<TSessionResult> GetErrorSessguard(NAuth::TSession& sess,
                                                          const TString& guardspace) const;

        static std::unique_ptr<TAuthChunk> GetAuthChunk(const NAuth::TSession& sess,
                                                        unsigned idx,
                                                        bool havePwd);
        std::unique_ptr<TNewSessionChunk> GetRenewSession(const TSessionResult& sessResult, NAuth::TSession& sess, const TString& domain) const;
        std::unique_ptr<TResignedCookiesChunk> GetResignedCookies(const TSessionResult& sessResult,
                                                                  NAuth::TSession& sess,
                                                                  TStringBuf resignForDomain) const;
    };
}
