#include "sign.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/signer.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/out_tokens.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>

namespace NPassport::NBb {
    TSignProcessor::TSignProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TSignProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::Sign);

        checker.CheckArg(TStrings::SIGN_SPACE, [&](const TString& value) {
            return consumer.IsSignAllowed(value);
        });

        return checker;
    }

    std::unique_ptr<TTypedValueResult> TSignProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& signSpace = TUtils::GetCheckedArg(Request_, TStrings::SIGN_SPACE);
        const TString& value = TUtils::GetCheckedArg(Request_, TStrings::VALUE);
        const TString& ttl = TUtils::GetUIntArg(Request_, TStrings::TTL, true);

        TString signedValue = Blackbox_.Signer().Sign(value, signSpace, ttl);

        return std::make_unique<TTypedValueResult>(TOutTokens::SIGNED_VALUE, signedValue);
    }
}
