#pragma once

#include "userinfo.h"

#include <util/generic/string.h>

#include <memory>
#include <optional>
#include <vector>

namespace NTvmAuth {
    class TCheckedUserTicket;
}

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TBlackboxImpl;
    class TBulkUserInfoResult;
    class TUserTicketResult;
    class TConsumer;
    class TGrantsChecker;

    class TUserTicketProcessor {
    public:
        TUserTicketProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TUserTicketResult> Process(const TConsumer& consumer);

    private:
        using TUserInfoResult = std::unique_ptr<TBulkUserInfoResult>;

        std::vector<TString> MakeUidList(const NTvmAuth::TCheckedUserTicket& t, const TString& ut) const;
        std::optional<TString> GetUidOfKid() const;
        std::unique_ptr<TUserTicketResult> TranslateResult(
            TUserInfoResult userinfo,
            const std::vector<TString>& uids,
            const std::optional<TString>& kid,
            const TUserInfoProcessor::TKidStatus& status,
            const TConsumer& consumer) const;

        TString GenerateUserTicketForKid(const TString& uidStr, const TConsumer& consumer) const;

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
    };

}
