#pragma once

#include <passport/infra/daemons/blackbox/src/domain/domain.h>
#include <passport/infra/daemons/blackbox/src/grants/consumer.h>
#include <passport/infra/daemons/blackbox/src/helpers/partitions_helper.h>

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TBlackboxImpl;
    class TBulkUserInfoResult;
    class TDbFetcher;
    class TDbProfile;
    class TUserInfoResult;
    class TGrantsChecker;

    class TUserInfoProcessor {
    public:
        TUserInfoProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request);

        TGrantsChecker CheckGrants(const TConsumer& consumer, bool throwOnError = true);
        std::unique_ptr<TBulkUserInfoResult> Process(const TConsumer& consumer);

        struct TKidStatus {
            TString Error;
        };

        std::unique_ptr<TBulkUserInfoResult> ProcessUserInfoByUidsImpl(
            const std::vector<TString>& uids,
            const std::optional<TString>& kid = {},
            TKidStatus* kidStatus = nullptr,
            TStringBuf method = "userinfo with identification by uid");

    private:
        std::unique_ptr<TBulkUserInfoResult> ProcessUserInfoByUids(const TString& uidArg);
        std::unique_ptr<TUserInfoResult> ProcessUserInfoImpl();

        bool InitLoginSid();
        bool InitByAuthorizationType();

        static std::unique_ptr<TUserInfoResult> GetErrorResult();

        static void FillKidStatus(const TDbFetcher& fetcher,
                                  const TString& uid,
                                  const TString& kid,
                                  TKidStatus& kidStatus);

    private:
        const TBlackboxImpl& Blackbox_;
        const NCommon::TRequest& Request_;
        TString Login_;
        TString Sid_;
        std::vector<TString> Sids_;
        TString Suid_;
        TString PublicId_;
        TDomain PddDomain_;
        bool ForceSid2_ = false;
        bool AllowScholar_ = false;
        TPartitionsHelper::TSettings PartitionsHelperSettings_;
    };

}
