#include "webauthn_credentials.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/webauthn_credentials_result.h>

#include <passport/infra/libs/cpp/dbpool/handle.h>

namespace NPassport::NBb {
    TWebauthnCredentialsProcessor::TWebauthnCredentialsProcessor(const TBlackboxImpl& impl, const NCommon::TRequest& request)
        : Blackbox_(impl)
        , Request_(request)
    {
    }

    TGrantsChecker TWebauthnCredentialsProcessor::CheckGrants(const TConsumer& consumer, bool throwOnError) {
        TGrantsChecker checker(Request_, consumer, throwOnError);

        checker.CheckMethodAllowed(TBlackboxMethods::WebauthnCredentials);

        return checker;
    }

    static const TString QUERY_START =
        "SELECT uid FROM webauthn_credentials WHERE credential_id='";

    std::unique_ptr<TWebauthnCredentialsResult> TWebauthnCredentialsProcessor::Process(const TConsumer& consumer) {
        CheckGrants(consumer);

        const TString& credId = TUtils::GetCheckedArg(Request_, TStrings::CREDENTIAL_ID);

        NDbPool::TBlockingHandle h(Blackbox_.CentralDb());
        TString query = NUtils::CreateStr(QUERY_START, h.EscapeQueryParam(credId), '\'');

        std::unique_ptr<NDbPool::TResult> dbResult = h.Query(query);
        TString uid;

        dbResult->Fetch(uid);

        if (uid.empty()) {
            return std::make_unique<TWebauthnCredentialsResult>(credId);
        }

        return std::make_unique<TWebauthnCredentialsResult>(credId, uid);
    }
}
