#pragma once

#include <util/generic/string.h>

#include <map>
#include <vector>

namespace NPassport::NBb {
    class TAnonymiser {
    public:
        using TFieldsMap = std::map<TString, TString>;

        void AddAttribute(const TString& name, const TString& value);
        void SetEmailDomain(const TString& prefix, const TString& body);
        void SetNickname(const TString& ru, const TString& en);

        // return true if field has been mapped
        bool MapEmail(TString& email, const TString& login, unsigned& num) const;
        bool MapAttribute(const TString& name, TString& value) const;
        static bool MapPhone(TString& phoneNumber);

    private:
        void MapNickname(TString& value) const;

        TFieldsMap AttrMap_;
        TString EmailDomPrefix_, EmailDomBody_;
        TString NicknameRu_, NicknameRuDots_, NicknameEn_, NicknameEnDots_;
    };
}
