#include "attributes.h"

#include <passport/infra/libs/cpp/utils/string/split.h>

namespace NPassport::NBb {
    TAttributesSettings::TAttributesSettings(const TString& requireGrants,
                                             const TString& binary,
                                             const TString& phoneGrants,
                                             const TString& deleted) {
        for (TString& a : NUtils::NormalizeListValue(requireGrants, ", ")) {
            RequireGrants_.insert(std::move(a));
        }

        for (TString& a : NUtils::NormalizeListValue(binary, ", ")) {
            Binary_.insert(std::move(a));
        }

        for (TString& a : NUtils::NormalizeListValue(phoneGrants, ", ")) {
            PhoneGrants_.insert(std::move(a));
        }

        for (TString& a : NUtils::NormalizeListValue(deleted, ", ")) {
            Deleted_.insert(std::move(a));
        }
    }

    bool TAttributesSettings::RequiresGrant(const TString& attr) const {
        return RequireGrants_.find(attr) != RequireGrants_.end();
    }

    bool TAttributesSettings::IsBinary(const TString& attr) const {
        return Binary_.find(attr) != Binary_.end();
    }

    bool TAttributesSettings::RequiresGrantPhone(const TString& attr) const {
        return PhoneGrants_.find(attr) != PhoneGrants_.end();
    }

    bool TAttributesSettings::IsDeleted(const TString& attr) const {
        return Deleted_.find(attr) != Deleted_.end();
    }
}
