#pragma once

#include <util/generic/string.h>

#include <set>

namespace NPassport::NBb {
    // Global attribute access settings
    class TAttributesSettings {
    public:
        TAttributesSettings(const TString& requireGrants,
                            const TString& binary,
                            const TString& phoneGrants,
                            const TString& deleted);

        using TAttrSet = std::set<TString>;

        bool RequiresGrant(const TString& attr) const;
        bool IsBinary(const TString& attr) const;
        bool RequiresGrantPhone(const TString& attr) const;
        bool IsDeleted(const TString& attr) const;

    private:
        TAttrSet RequireGrants_;
        TAttrSet Binary_;
        TAttrSet PhoneGrants_;
        TAttrSet Deleted_;
    };
}
