#include "db_types.h"

namespace NPassport::NBb {
    const TString TAlias::PORTAL_LOGIN = "1";
    const TString TAlias::MAIL_LOGIN = "2";
    const TString TAlias::NAROD_MAIL_LOGIN = "3";
    const TString TAlias::LITE_LOGIN = "5";
    const TString TAlias::SOCIAL_LOGIN = "6";
    const TString TAlias::PDD_MASTER_LOGIN = "7";
    const TString TAlias::PDD_ALIAS_LOGIN = "8";
    const TString TAlias::ALT_DOMAIN_LOGIN = "9";
    const TString TAlias::PHONY_LOGIN = "10";
    const TString TAlias::PHONE_NUMBER = "11";
    const TString TAlias::MAILISH_LOGIN = "12";
    const TString TAlias::YANDEXOID_LOGIN = "13";
    const TString TAlias::KINOPOISK_ID = "15";
    const TString TAlias::UBER_ID = "16";
    const TString TAlias::YAMBOT = "17";
    const TString TAlias::COLONKISH = "18";
    const TString TAlias::PUBLICID = "19";
    const TString TAlias::OLDPUBLICID = "20";
    const TString TAlias::NEOPHONISH = "21";
    const TString TAlias::KIDDISH = "22";
    const TString TAlias::SCHOLAR = "23";
    const TString TAlias::FEDERAL = "24";
    const TString TAlias::BANK_PHONE_NUMBER = "25";

    const TString TAttr::ACCOUNT_REGISTRATION_DATETIME = "1";
    const TString TAttr::ACCOUNT_USER_DEFINED_LOGIN = "2";
    const TString TAttr::ACCOUNT_DISABLED = "3";
    const TString TAttr::ACCOUNT_GLOBAL_LOGOUT_DATETIME = "4";
    const TString TAttr::ACCOUNT_PDD_AGREEMENT_ACCEPTED = "6";
    const TString TAttr::ACCOUNT_PDD_ADMIN = "7";
    const TString TAttr::ACCOUNT_BETATESTER = "8";
    const TString TAttr::ACCOUNT_CORPORATE = "9";
    const TString TAttr::ACCOUNT_VIP = "10";
    const TString TAttr::ACCOUNT_TEST = "11";
    const TString TAttr::ACCOUNT_EMPLOYEE = "12";
    const TString TAttr::ACCOUNT_MAILLIST = "13";
    const TString TAttr::ACCOUNT_DEFAULT_EMAIL = "14";
    const TString TAttr::PERSON_CONTACT_PHONE = "15";
    const TString TAttr::ACCOUNT_DISPLAY_NAME = "16";
    const TString TAttr::KARMA_VALUE = "17";
    const TString TAttr::KARMA_ACTIVATION_DATETIME = "18";
    const TString TAttr::PASSWORD_ENCRYPTED = "19";
    const TString TAttr::PASSWORD_UPDATE_DATETIME = "20";
    const TString TAttr::PASSWORD_QUALITY = "21";
    const TString TAttr::PASSWORD_FORCED_CHANGING_REASON = "22";
    const TString TAttr::PASSWORD_CREATING_REQUIRED = "23";
    const TString TAttr::ACCOUNT_STRONG_PASSWORD_REQUIRED = "24";
    const TString TAttr::HINT_QUESTION_SERIALIZED = "25";
    const TString TAttr::HINT_ANSWER_ENCRYPTED = "26";
    const TString TAttr::PERSON_FIRSTNAME = "27";
    const TString TAttr::PERSON_LASTNAME = "28";
    const TString TAttr::PERSON_GENDER = "29";
    const TString TAttr::PERSON_BIRTHDATE = "30";
    const TString TAttr::PERSON_COUNTRY = "31";
    const TString TAttr::PERSON_CITY = "32";
    const TString TAttr::PERSON_TIMEZONE = "33";
    const TString TAttr::PERSON_LANGUAGE = "34";
    const TString TAttr::PHONE_NUMBER = "35";                // I am synthetic now
    const TString TAttr::PHONE_CONFIRMATION_DATETIME = "36"; // I am synthetic too
    const TString TAttr::SUBSCRIPTION_MAIL_HOST_ID = "38";
    const TString TAttr::SUBSCRIPTION_MAIL_LOGIN_RULE = "39";
    const TString TAttr::SUBSCRIPTION_5 = "44";
    const TString TAttr::SUBSCRIPTION_6 = "45";
    const TString TAttr::SUBSCRIPTION_9 = "46";
    const TString TAttr::SUBSCRIPTION_14 = "48";
    const TString TAttr::SUBSCRIPTION_17 = "49";
    const TString TAttr::SUBSCRIPTION_19 = "50";
    const TString TAttr::SUBSCRIPTION_23 = "52";
    const TString TAttr::SUBSCRIPTION_24 = "53";
    const TString TAttr::SUBSCRIPTION_25 = "54";
    const TString TAttr::SUBSCRIPTION_26 = "55";
    const TString TAttr::SUBSCRIPTION_JABBER_LOGIN_RULE = "56";
    const TString TAttr::SUBSCRIPTION_29 = "57";
    const TString TAttr::SUBSCRIPTION_30 = "58";
    const TString TAttr::SUBSCRIPTION_31 = "59";
    const TString TAttr::SUBSCRIPTION_37 = "60";
    const TString TAttr::SUBSCRIPTION_38 = "61";
    const TString TAttr::SUBSCRIPTION_39 = "62";
    const TString TAttr::SUBSCRIPTION_40 = "63";
    const TString TAttr::SUBSCRIPTION_41 = "64";
    const TString TAttr::SUBSCRIPTION_WWWDGT_MODE = "65";
    const TString TAttr::SUBSCRIPTION_DISK_LOGIN_RULE = "66";
    const TString TAttr::SUBSCRIPTION_47 = "68";
    const TString TAttr::SUBSCRIPTION_48 = "69";
    const TString TAttr::SUBSCRIPTION_49 = "70";
    const TString TAttr::SUBSCRIPTION_50 = "71";
    const TString TAttr::SUBSCRIPTION_51 = "72";
    const TString TAttr::SUBSCRIPTION_52 = "73";
    const TString TAttr::SUBSCRIPTION_53 = "74";
    const TString TAttr::SUBSCRIPTION_54 = "75";
    const TString TAttr::SUBSCRIPTION_55 = "76";
    const TString TAttr::SUBSCRIPTION_57 = "77";
    const TString TAttr::SUBSCRIPTION_59 = "78";
    const TString TAttr::SUBSCRIPTION_60 = "79";
    const TString TAttr::SUBSCRIPTION_64 = "80";
    const TString TAttr::SUBSCRIPTION_76 = "81";
    const TString TAttr::SUBSCRIPTION_77 = "82";
    const TString TAttr::SUBSCRIPTION_78 = "83";
    const TString TAttr::SUBSCRIPTION_80 = "84";
    const TString TAttr::SUBSCRIPTION_81 = "85";
    const TString TAttr::SUBSCRIPTION_666 = "86";
    const TString TAttr::SUBSCRIPTION_667 = "87";
    const TString TAttr::SUBSCRIPTION_83 = "89";
    const TString TAttr::SUBSCRIPTION_84 = "90";
    const TString TAttr::SUBSCRIPTION_85 = "91";
    const TString TAttr::SUBSCRIPTION_86 = "92";
    const TString TAttr::SUBSCRIPTION_87 = "93";
    const TString TAttr::ACCOUNT_AD_CAMPAIGN_PARTICIPANT = "94";
    const TString TAttr::SUBSCRIPTION_88 = "95";
    const TString TAttr::SUBSCRIPTION_90 = "96";
    const TString TAttr::SUBSCRIPTION_91 = "97";
    const TString TAttr::AVATAR_DEFAULT = "98";
    const TString TAttr::ACCOUNT_BROWSER_KEY = "101";
    const TString TAttr::SUBSCRIPTION_93 = "103";
    const TString TAttr::ACCOUNT_TOTP_SECRET = "104";
    const TString TAttr::SUBSCRIPTION_94 = "105";
    const TString TAttr::ACCOUNT_TOTP_CHECK_TIME = "106";
    const TString TAttr::ACCOUNT_ENABLE_APP_PASSWORD = "107";
    const TString TAttr::SUBSCRIPTION_95 = "108";
    const TString TAttr::SUBSCRIPTION_96 = "109";
    const TString TAttr::PHONES_SECURE = "110";
    const TString TAttr::PHONES_DEFAULT = "111";
    const TString TAttr::SUBSCRIPTION_97 = "112";
    const TString TAttr::SUBSCRIPTION_201 = "113";
    const TString TAttr::SUBSCRIPTION_202 = "114";
    const TString TAttr::SUBSCRIPTION_203 = "115";
    const TString TAttr::SUBSCRIPTION_204 = "116";
    const TString TAttr::SUBSCRIPTION_205 = "117";
    const TString TAttr::ACCOUNT_FAILED_PIN_CHECKS_COUNT = "118";
    const TString TAttr::SUBSCRIPTION_KINOPOISK = "119";
    const TString TAttr::SUBSCRIPTION_REALTY = "120";
    const TString TAttr::SUBSCRIPTION_REALTY_AGENT = "121";
    const TString TAttr::ACCOUNT_TOTP_UPDATE_DATETIME = "123";
    const TString TAttr::SUBSCRIPTION_RABOTA = "124";
    const TString TAttr::SUBSCRIPTION_RABOTA_EMPLOYEE = "125";
    const TString TAttr::SUBSCRIPTION_RABOTA_BLUE_COLLAR = "126";
    const TString TAttr::SUBSCRIPTION_RABOTA_EMPLOYER = "127";
    const TString TAttr::SUBSCRIPTION_RABOTA_MOBILE_APP = "128";
    const TString TAttr::SUBSCRIPTION_RABOTA_MOBILE_SITE = "129";
    const TString TAttr::SUBSCRIPTION_REALTY_MODERATOR = "130";
    const TString TAttr::SUBSCRIPTION_TAXI = "131";
    const TString TAttr::ACCOUNT_SHARED = "132";
    const TString TAttr::ACCOUNT_SHOW_2FA_PROMO = "133";
    const TString TAttr::REVOKER_TOKENS = "134";
    const TString TAttr::REVOKER_APP_PASSWORDS = "135";
    const TString TAttr::REVOKER_WEB_SESSIONS = "136";
    const TString TAttr::SUBSCRIPTION_REALTY_APP_IOS = "137";
    const TString TAttr::SUBSCRIPTION_REALTY_APP_ANDROID = "138";
    const TString TAttr::SUBSCRIPTION_SITE_SEARCH = "139";
    const TString TAttr::ACCOUNT_AUTH_CHALLENGE_EMAIL_DATETIME = "140";
    const TString TAttr::ACCOUNT_FAILED_AUTH_CHALLENGE_CHECKS_COUNTER = "141";
    const TString TAttr::SUBSCRIPTION_TOLOKA = "142";
    const TString TAttr::ACCOUNT_TOTP_JUNK_SECRET = "143";
    const TString TAttr::ACCOUNT_MIGRATED_FROM_PHONISH = "144";
    const TString TAttr::ACCOUNT_MIGRATED_TO = "145";
    const TString TAttr::ACCOUNT_AUDIENCE_ON = "146";
    const TString TAttr::SUBSCRIPTION_TELEPHONY = "148";
    const TString TAttr::ACCOUNT_IS_MUSIC_COMPLETE_PHONISH = "149";
    const TString TAttr::ACCOUNT_IS_BILLING_COMPLETE_PHONISH = "150";
    const TString TAttr::ACCOUNT_IS_PHONISH_COMPLETION_FINISHED = "151";
    const TString TAttr::SUBSCRIPTION_MUSIC_PREMIUM = "152";
    const TString TAttr::ACCOUNT_DELETION_OPERATION_STARTED_AT = "153";
    const TString TAttr::ACCOUNT_IS_CONNECT_ADMIN = "154";
    const TString TAttr::ACCOUNT_RFC_TOTP_SECRET = "155";
    const TString TAttr::ACCOUNT_RFC_TOTP_CHECK_TIME = "156";
    const TString TAttr::ACCOUNT_IS_MONEY_AGREEMENT_ACCEPTED = "157";
    const TString TAttr::ACCOUNT_ADDITIONAL_DATA_ASKED = "158";
    const TString TAttr::ACCOUNT_ADDITIONAL_DATA_ASK_NEXT_DATETIME = "159";
    const TString TAttr::ACCOUNT_PLUS_ENABLED = "160";
    const TString TAttr::ACCOUNT_PLUS_TRIAL_USED_TS = "161";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS = "162";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS = "163";
    const TString TAttr::ACCOUNT_PLUS_NEXT_CHARGE_TS = "164";
    const TString TAttr::ACCOUNT_ENABLE_SEARCH_BY_PHONE_ALIAS = "165";
    const TString TAttr::ACCOUNT_CREATOR_UID = "166";
    const TString TAttr::ACCOUNT_OTT_SUBSCRIPTION = "167";
    const TString TAttr::ACCOUNT_EXTERNAL_ORGANIZATION_IDS = "168";
    const TString TAttr::TAKEOUT_IS_EXTRACT_IN_PROGRESS = "169";
    const TString TAttr::TAKEOUT_ARCHIVE_URL = "170";
    const TString TAttr::TAKEOUT_ARCHIVE_PASSWORD = "171";
    const TString TAttr::TAKEOUT_ARCHIVE_CREATED_AT = "172";
    const TString TAttr::TAKEOUT_FAIL_EXTRACT_AT = "173";
    const TString TAttr::PERSON_DONT_USE_DISPLAYNAME_AS_PUBLICNAME = "174";
    const TString TAttr::ACCOUNT_PLUS_FAMILY_ROLE = "175";
    const TString TAttr::SUBSCRIPTION_DRIVE = "176";
    const TString TAttr::ACCOUNT_IS_EASILY_HACKED = "177";
    const TString TAttr::INVESTMENTS_IS_REGISTERED = "178";
    const TString TAttr::ACCOUNT_PHONISH_NAMESPACE = "179";
    const TString TAttr::ACCOUNT_BILLING_FEATURES = "180";
    const TString TAttr::ACCOUNT_MAIL_OR_MESSENGER_LOGIN_ALLOWED = "181";
    const TString TAttr::ACCOUNT_QR_CODE_LOGIN_ALLOWED = "182";
    const TString TAttr::ACCOUNT_PUBLIC_ID_VERSION = "183";
    const TString TAttr::TAKEOUT_SUBSCRIPTION = "184";
    const TString TAttr::PERSON_SHOW_FIO_IN_PUBLIC_NAME = "185";
    const TString TAttr::ACCOUNT_USER_DEFINED_PUBLIC_ID = "186";
    const TString TAttr::ACCOUNT_SMS_CODE_LOGIN_FORBIDDEN = "187";
    const TString TAttr::ACCOUNT_FORCE_CHALLENGE = "188";
    const TString TAttr::ACCOUNT_HIDE_YANDEX_DOMAINS_EMAILS = "189";
    const TString TAttr::SUBSCRIPTION_TELEMOST = "190";
    const TString TAttr::ACCOUNT_ALLOW_WEBDAV_BY_PASSWORD = "191";
    const TString TAttr::ACCOUNT_ALLOW_CALENDAR_BY_PASSWORD = "192";
    const TString TAttr::ACCOUNT_PLUS_CASHBACK_ENABLED = "194";
    const TString TAttr::PASSWORD_FORCED_CHANGING_TIME = "195";
    const TString TAttr::ACCOUNT_IS_VERIFIED = "196";
    const TString TAttr::SUBSCRIPTION_MAILPRO = "197";
    const TString TAttr::SUBSCRIPTION_MAILPRO_ON = "198";
    const TString TAttr::SUBSCRIPTION_MAILPRO_OFF = "199";
    const TString TAttr::ACCOUNT_SMS_2FA_ON = "200";
    const TString TAttr::ACCOUNT_FORBID_DISABLING_SMS_2FA = "201";
    const TString TAttr::ACCOUNT_CONTENT_RATING_CLASS = "202";
    const TString TAttr::SUBSCRIPTION_MAIL_STATUS = "203";
    const TString TAttr::TAKEOUT_DELETE_SUBSCRIPTION = "204";
    const TString TAttr::ACCOUNT_MUSIC_CONTENT_RATING_CLASS = "205";
    const TString TAttr::ACCOUNT_VIDEO_CONTENT_RATING_CLASS = "206";
    const TString TAttr::ACCOUNT_UNSUBSCRIBED_FROM_MAILLISTS = "207";
    const TString TAttr::ACCOUNT_PERSONAL_DATA_PUBLIC_ACCESS_ALLOWED = "208";
    const TString TAttr::ACCOUNT_PERSONAL_DATA_THIRD_PARTY_PROCESSING_ALLOWED = "209";
    const TString TAttr::ACCOUNT_IS_CHILD = "210";
    const TString TAttr::ACCOUNT_SCHOLAR_PASSWORD = "211";
    const TString TAttr::PERSON_FIRSTNAME_GLOBAL = "212";
    const TString TAttr::PERSON_LASTNAME_GLOBAL = "213";
    const TString TAttr::PASSWORD_FORCED_CHANGING_SUSPENDED_AT = "214";
    const TString TAttr::ACCOUNT_BANK_SUBSCRIPTION = "215";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIPTION_LEVEL = "216";
    const TString TAttr::ACCOUNT_PLUS_IS_FROZEN = "217";
    const TString TAttr::ACCOUNT_FAMILY_PAY = "218";
    const TString TAttr::ACCOUNT_IS_DOCUMENTS_AGREEMENT_ACCEPTED = "219";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIBER_STATE = "220";
    const TString TAttr::ACCOUNT_TOTP_YAKEY_DEVICE_IDS = "221";
    const TString TAttr::ACCOUNT_FAMILY_CHILDREN_MANAGEMENT = "222";

    // Synthetic attributes:
    const TString TAttr::PERSON_BIRTH_DAY = "1001";
    const TString TAttr::PERSON_BIRTH_YEAR = "1002";
    const TString TAttr::ACCOUNT_2FA_ON = "1003";
    const TString TAttr::ACCOUNT_2FA_PIN = "1004";
    const TString TAttr::ACCOUNT_HAVE_PASSWORD = "1005";
    const TString TAttr::ACCOUNT_HAVE_HINT = "1006";
    const TString TAttr::PERSON_FIO = "1007";
    const TString TAttr::ACCOUNT_NORMALIZED_LOGIN = "1008";
    const TString TAttr::ACCOUNT_IS_AVAILABLE = "1009";
    const TString TAttr::ACCOUNT_SECRET_IDS = "1010";
    const TString TAttr::ACCOUNT_HAVE_ORGANIZATION_NAME = "1011";
    const TString TAttr::ACCOUNT_PIN_LENGTH = "1012";
    const TString TAttr::ACCOUNT_PROTECTION_LEVEL = "1013";
    const TString TAttr::ACCOUNT_RFC_2FA_ON = "1014";
    const TString TAttr::ACCOUNT_HAVE_PLUS = "1015";
    const TString TAttr::ACCOUNT_KINOPOISK_OTT_SUBSCRIPTION_NAME = "1016";
    const TString TAttr::ACCOUNT_CONNECT_ORGANIZATION_IDS = "1017";
    const TString TAttr::ACCOUNT_PLUS_TRIAL_USED_TS_SYNT = "1018";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS_SYNT = "1019";
    const TString TAttr::ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS_SYNT = "1020";
    const TString TAttr::ACCOUNT_PLUS_NEXT_CHARGE_TS_SYNT = "1021";
    const TString TAttr::ACCOUNT_PLUS_FAMILY_ROLE_SYNT = "1022";
    const TString TAttr::ACCOUNT_SUGGEST_PUBLIC_NAME = "1023";
    const TString TAttr::ACCOUNT_HAS_CUSTOM_PUBLIC_ID = "1024";
    const TString TAttr::ACCOUNT_HAS_PLUS_CASHBACK = "1025";
    const TString TAttr::ACCOUNT_MUSIC_CONTENT_RATING_KLASS = "1026";
    const TString TAttr::ACCOUNT_VIDEO_CONTENT_RATING_KLASS = "1027";
    const TString TAttr::ACCOUNT_PLUS_MAPPED_SUBSCRIPTION_LEVEL = "1028";
    const TString TAttr::ACCOUNT_PDD_ORGANIZATION_ID = "1031";
    const TString TAttr::ACCOUNT_COMPLETION_RECOMMENDED = "1032";
    const TString TAttr::ACCOUNT_IS_KID = "1033";
    const TString TAttr::ACCOUNT_FAMILY_CHILDREN_MANAGEMENT_SYNT = "1034";

    bool TAttr::IsSynthetic(const TString& attr) {
        // currently all 4-digit attributes are synthetic
        return attr.size() > 3 || TAttr::PHONE_NUMBER == attr || TAttr::PHONE_CONFIRMATION_DATETIME == attr;
    }

    const TString TExtendedAttrType::NONE = "0";
    const TString TExtendedAttrType::PHONE = "1";
    const TString TExtendedAttrType::EMAIL = "2";
    const TString TExtendedAttrType::WEBAUTHN = "3";
    const TString TExtendedAttrType::PHONE_OPERATION = "101";
    const TString TExtendedAttrType::PHONE_BINDINGS = "102";
    const size_t TExtendedAttrType::MAX_SYN_EXTENDED_COUNT = 8;

    const TString TPhoneAttr::NUMBER = "1";
    const TString TPhoneAttr::CREATED = "2";
    const TString TPhoneAttr::BOUND = "3";
    const TString TPhoneAttr::CONFIRMED = "4";
    const TString TPhoneAttr::ADMITTED = "5";
    const TString TPhoneAttr::SECURED = "6";
    const TString TPhoneAttr::FORMATTED_NUMBER = "101";
    const TString TPhoneAttr::E164_NUMBER = "102";
    const TString TPhoneAttr::MASKED_FORMATTED_NUMBER = "103";
    const TString TPhoneAttr::MASKED_E164_NUMBER = "104";
    const TString TPhoneAttr::IS_CONFIRMED = "105";
    const TString TPhoneAttr::IS_BOUND = "106";
    const TString TPhoneAttr::IS_DEFAULT = "107";
    const TString TPhoneAttr::IS_SECURED = "108";
    const TString TPhoneAttr::IS_BANK = "109";

    bool TPhoneAttr::IsSynthetic(const TString& attr) {
        // currently all 3-digit extended attributes are synthetic
        return attr.size() > 2;
    }

    const TString TEmailAttr::ADDRESS = "1";
    const TString TEmailAttr::CREATED = "2";
    const TString TEmailAttr::CONFIRMED = "3";
    const TString TEmailAttr::BOUND = "4";
    const TString TEmailAttr::IS_RPOP = "5";
    const TString TEmailAttr::IS_UNSAFE = "6";
    const TString TEmailAttr::IS_SILENT = "7";

    bool TEmailAttr::IsSynthetic(const TString& attr) {
        // currently all 3-digit extended attributes are synthetic
        return attr.size() > 2;
    }

    const TString TWebauthnAttr::EXTERNAL_ID = "1";
    const TString TWebauthnAttr::PUBLIC_KEY = "2";
    const TString TWebauthnAttr::SIGN_COUNT = "3";
    const TString TWebauthnAttr::DEVICE_NAME = "4";
    const TString TWebauthnAttr::CREATED = "5";
    const TString TWebauthnAttr::RELYING_PARTY_ID = "6";
    const TString TWebauthnAttr::OS_FAMILY_ID = "7";
    const TString TWebauthnAttr::BROWSER_ID = "8";

    bool TWebauthnAttr::IsSynthetic(const TString& attr) {
        // currently all 3-digit extended attributes are synthetic
        return attr.size() > 2;
    }

    const TString TOAuthTokenAttr::TOKEN_ID = "0";
    const TString TOAuthTokenAttr::ACCESS_TOKEN = "1";
    const TString TOAuthTokenAttr::SCOPE_IDS = "2";
    const TString TOAuthTokenAttr::UID = "3";
    const TString TOAuthTokenAttr::CLIENT_ID = "4";
    const TString TOAuthTokenAttr::DEVICE_ID = "5";
    const TString TOAuthTokenAttr::DEVICE_NAME = "6";
    const TString TOAuthTokenAttr::EXPIRES = "7";
    const TString TOAuthTokenAttr::IS_REFRESHABLE = "8";
    const TString TOAuthTokenAttr::CREATED = "9";
    const TString TOAuthTokenAttr::ISSUED = "10";
    const TString TOAuthTokenAttr::META = "11";
    const TString TOAuthTokenAttr::ALIAS = "12";
    const TString TOAuthTokenAttr::COMMENT = "13";
    const TString TOAuthTokenAttr::X_TOKEN_ID = "14";
    const TString TOAuthTokenAttr::PAYMENT_AUTH_CONTEXT_ID = "15";
    const TString TOAuthTokenAttr::PAYMENT_AUTH_SCOPE_ADDENDUM = "16";
    const TString TOAuthTokenAttr::LOGIN_ID = "17";
    const TString TOAuthTokenAttr::APP_PLATFORM = "18";
    const TString TOAuthTokenAttr::IS_XTOKEN_TRUSTED = "19";

    const TString TOAuthTokenAttr::IS_STATELESS = "1001";

    bool TOAuthTokenAttr::IsSynthetic(const TString& attr) {
        // currently all 4-digit extended attributes are synthetic
        return attr.size() > 3;
    }

    const TString TOAuthClientAttr::CLIENT_ID = "0";
    const TString TOAuthClientAttr::UID = "1";
    const TString TOAuthClientAttr::SCOPE_IDS = "2";
    const TString TOAuthClientAttr::SECRET = "3";
    const TString TOAuthClientAttr::OLD_SECRET = "4";
    const TString TOAuthClientAttr::CALLBACK = "5";
    const TString TOAuthClientAttr::APPROVAL_STATUS = "6";
    const TString TOAuthClientAttr::IS_BLOCKED = "7";
    const TString TOAuthClientAttr::DEFAULT_TITLE = "8";
    const TString TOAuthClientAttr::TITLE_RU = "9";
    const TString TOAuthClientAttr::TITLE_EN = "10";
    const TString TOAuthClientAttr::TITLE_TR = "11";
    const TString TOAuthClientAttr::GLOGOUTED = "12";
    const TString TOAuthClientAttr::CREATED = "13";
    const TString TOAuthClientAttr::MODIFIED = "14";
    const TString TOAuthClientAttr::DISPLAY_ID = "15";
    const TString TOAuthClientAttr::SERVICES = "16";
    const TString TOAuthClientAttr::EVENTS = "17";
    const TString TOAuthClientAttr::DEFAULT_DESCRIPTION = "18";
    const TString TOAuthClientAttr::ICON = "19";
    const TString TOAuthClientAttr::HOMEPAGE = "20";
    const TString TOAuthClientAttr::TITLE_UK = "21";
    const TString TOAuthClientAttr::DESCRIPTION_RU = "22";
    const TString TOAuthClientAttr::DESCRIPTION_EN = "23";
    const TString TOAuthClientAttr::DESCRIPTION_TR = "24";
    const TString TOAuthClientAttr::DESCRIPTION_UK = "25";
    const TString TOAuthClientAttr::IS_YANDEX = "26";
    const TString TOAuthClientAttr::ICON_ID = "27";
    const TString TOAuthClientAttr::TELEGRAM_BOT_NAME = "28";
    const TString TOAuthClientAttr::DELETED = "29";
    const TString TOAuthClientAttr::ALLOW_GRANTTYPE_PASSWORD = "30";
    const TString TOAuthClientAttr::REDIRECT_URIS = "31";
    const TString TOAuthClientAttr::IOS_DEFAULT_APP_ID = "32";
    const TString TOAuthClientAttr::ANDROID_DEFAULT_PACKAGE_NAME = "33";
    const TString TOAuthClientAttr::ANDROID_CERT_FINGERPRINTS = "34";
    const TString TOAuthClientAttr::IOS_APPSTORE_URL = "35";
    const TString TOAuthClientAttr::ANDROID_APPSTORE_URL = "36";
    const TString TOAuthClientAttr::OWNER_UIDS = "37";
    const TString TOAuthClientAttr::OWNER_GROUPS = "38";
    const TString TOAuthClientAttr::OWNER_GROUP_UIDS = "39";
    const TString TOAuthClientAttr::IOS_EXTRA_APP_IDS = "40";
    const TString TOAuthClientAttr::ANDROID_EXTRA_PACKAGE_NAMES = "41";

    bool TOAuthClientAttr::IsSynthetic(const TString& attr) {
        // currently all 4-digit extended attributes are synthetic
        return attr.size() > 3;
    }

    const TString TMailStatus::ACTIVE = "1";
    const TString TMailStatus::FROZEN = "2";
}
