#pragma once

#include <util/generic/string.h>

namespace NPassport::NBb {
    // Value types in 'alias' table
    class TAlias {
    public:
        static const TString PORTAL_LOGIN;      // "1"
        static const TString MAIL_LOGIN;        // "2"
        static const TString NAROD_MAIL_LOGIN;  // "3"
        static const TString LITE_LOGIN;        // "5"
        static const TString SOCIAL_LOGIN;      // "6"
        static const TString PDD_MASTER_LOGIN;  // "7"
        static const TString PDD_ALIAS_LOGIN;   // "8"
        static const TString ALT_DOMAIN_LOGIN;  // "9"
        static const TString PHONY_LOGIN;       // "10"
        static const TString PHONE_NUMBER;      // "11"
        static const TString MAILISH_LOGIN;     // "12"
        static const TString YANDEXOID_LOGIN;   // "13"
        static const TString KINOPOISK_ID;      // "15"
        static const TString UBER_ID;           // "16"
        static const TString YAMBOT;            // "17"
        static const TString COLONKISH;         // "18"
        static const TString PUBLICID;          // "19"
        static const TString OLDPUBLICID;       // "20"
        static const TString NEOPHONISH;        // "21"
        static const TString KIDDISH;           // "22"
        static const TString SCHOLAR;           // "23"
        static const TString FEDERAL;           // "24"
        static const TString BANK_PHONE_NUMBER; // "25"
    };

    class TAttr {
    public:
        static const TString ACCOUNT_REGISTRATION_DATETIME;
        static const TString ACCOUNT_USER_DEFINED_LOGIN;
        static const TString ACCOUNT_DISABLED;
        static const TString ACCOUNT_GLOBAL_LOGOUT_DATETIME;
        static const TString ACCOUNT_PDD_AGREEMENT_ACCEPTED;
        static const TString ACCOUNT_PDD_ADMIN;
        static const TString ACCOUNT_BETATESTER;
        static const TString ACCOUNT_CORPORATE;
        static const TString ACCOUNT_VIP;
        static const TString ACCOUNT_TEST;
        static const TString ACCOUNT_EMPLOYEE;
        static const TString ACCOUNT_MAILLIST;
        static const TString ACCOUNT_DEFAULT_EMAIL;
        static const TString PERSON_CONTACT_PHONE;
        static const TString ACCOUNT_DISPLAY_NAME;
        static const TString KARMA_VALUE;
        static const TString KARMA_ACTIVATION_DATETIME;
        static const TString PASSWORD_ENCRYPTED;
        static const TString PASSWORD_UPDATE_DATETIME;
        static const TString PASSWORD_QUALITY;
        static const TString PASSWORD_FORCED_CHANGING_REASON;
        static const TString PASSWORD_CREATING_REQUIRED;
        static const TString ACCOUNT_STRONG_PASSWORD_REQUIRED;
        static const TString HINT_QUESTION_SERIALIZED;
        static const TString HINT_ANSWER_ENCRYPTED;
        static const TString PERSON_FIRSTNAME;
        static const TString PERSON_LASTNAME;
        static const TString PERSON_GENDER;
        static const TString PERSON_BIRTHDATE;
        static const TString PERSON_COUNTRY;
        static const TString PERSON_CITY;
        static const TString PERSON_TIMEZONE;
        static const TString PERSON_LANGUAGE;
        static const TString PHONE_NUMBER;
        static const TString PHONE_CONFIRMATION_DATETIME;
        static const TString SUBSCRIPTION_MAIL_HOST_ID;
        static const TString SUBSCRIPTION_MAIL_LOGIN_RULE;
        static const TString SUBSCRIPTION_5;
        static const TString SUBSCRIPTION_6;
        static const TString SUBSCRIPTION_9;
        static const TString SUBSCRIPTION_14;
        static const TString SUBSCRIPTION_17;
        static const TString SUBSCRIPTION_19;
        static const TString SUBSCRIPTION_23;
        static const TString SUBSCRIPTION_24;
        static const TString SUBSCRIPTION_25;
        static const TString SUBSCRIPTION_26;
        static const TString SUBSCRIPTION_JABBER_LOGIN_RULE;
        static const TString SUBSCRIPTION_29;
        static const TString SUBSCRIPTION_30;
        static const TString SUBSCRIPTION_31;
        static const TString SUBSCRIPTION_37;
        static const TString SUBSCRIPTION_38;
        static const TString SUBSCRIPTION_39;
        static const TString SUBSCRIPTION_40;
        static const TString SUBSCRIPTION_41;
        static const TString SUBSCRIPTION_WWWDGT_MODE;
        static const TString SUBSCRIPTION_DISK_LOGIN_RULE;
        static const TString SUBSCRIPTION_47;
        static const TString SUBSCRIPTION_48;
        static const TString SUBSCRIPTION_49;
        static const TString SUBSCRIPTION_50;
        static const TString SUBSCRIPTION_51;
        static const TString SUBSCRIPTION_52;
        static const TString SUBSCRIPTION_53;
        static const TString SUBSCRIPTION_54;
        static const TString SUBSCRIPTION_55;
        static const TString SUBSCRIPTION_57;
        static const TString SUBSCRIPTION_59;
        static const TString SUBSCRIPTION_60;
        static const TString SUBSCRIPTION_64;
        static const TString SUBSCRIPTION_76;
        static const TString SUBSCRIPTION_77;
        static const TString SUBSCRIPTION_78;
        static const TString SUBSCRIPTION_80;
        static const TString SUBSCRIPTION_81;
        static const TString SUBSCRIPTION_666;
        static const TString SUBSCRIPTION_667;
        static const TString SUBSCRIPTION_83;
        static const TString SUBSCRIPTION_84;
        static const TString SUBSCRIPTION_85;
        static const TString SUBSCRIPTION_86;
        static const TString SUBSCRIPTION_87;
        static const TString ACCOUNT_AD_CAMPAIGN_PARTICIPANT;
        static const TString SUBSCRIPTION_88;
        static const TString SUBSCRIPTION_90;
        static const TString SUBSCRIPTION_91;
        static const TString AVATAR_DEFAULT;
        static const TString ACCOUNT_BROWSER_KEY;
        static const TString SUBSCRIPTION_93;
        static const TString ACCOUNT_TOTP_SECRET;
        static const TString SUBSCRIPTION_94;
        static const TString ACCOUNT_TOTP_CHECK_TIME;
        static const TString ACCOUNT_ENABLE_APP_PASSWORD;
        static const TString SUBSCRIPTION_95;
        static const TString SUBSCRIPTION_96;
        static const TString PHONES_SECURE;
        static const TString PHONES_DEFAULT;
        static const TString SUBSCRIPTION_97;
        static const TString SUBSCRIPTION_201;
        static const TString SUBSCRIPTION_202;
        static const TString SUBSCRIPTION_203;
        static const TString SUBSCRIPTION_204;
        static const TString SUBSCRIPTION_205;
        static const TString ACCOUNT_FAILED_PIN_CHECKS_COUNT;
        static const TString SUBSCRIPTION_KINOPOISK;
        static const TString SUBSCRIPTION_REALTY;
        static const TString SUBSCRIPTION_REALTY_AGENT;
        static const TString ACCOUNT_TOTP_UPDATE_DATETIME;
        static const TString SUBSCRIPTION_RABOTA;
        static const TString SUBSCRIPTION_RABOTA_EMPLOYEE;
        static const TString SUBSCRIPTION_RABOTA_BLUE_COLLAR;
        static const TString SUBSCRIPTION_RABOTA_EMPLOYER;
        static const TString SUBSCRIPTION_RABOTA_MOBILE_APP;
        static const TString SUBSCRIPTION_RABOTA_MOBILE_SITE;
        static const TString SUBSCRIPTION_REALTY_MODERATOR;
        static const TString SUBSCRIPTION_TAXI;
        static const TString ACCOUNT_SHARED;
        static const TString ACCOUNT_SHOW_2FA_PROMO;
        static const TString REVOKER_TOKENS;
        static const TString REVOKER_APP_PASSWORDS;
        static const TString REVOKER_WEB_SESSIONS;
        static const TString SUBSCRIPTION_REALTY_APP_IOS;
        static const TString SUBSCRIPTION_REALTY_APP_ANDROID;
        static const TString SUBSCRIPTION_SITE_SEARCH;
        static const TString ACCOUNT_AUTH_CHALLENGE_EMAIL_DATETIME;
        static const TString ACCOUNT_FAILED_AUTH_CHALLENGE_CHECKS_COUNTER;
        static const TString SUBSCRIPTION_TOLOKA;
        static const TString ACCOUNT_TOTP_JUNK_SECRET;
        static const TString ACCOUNT_MIGRATED_FROM_PHONISH;
        static const TString ACCOUNT_MIGRATED_TO;
        static const TString ACCOUNT_AUDIENCE_ON;
        static const TString SUBSCRIPTION_TELEPHONY;
        static const TString ACCOUNT_IS_MUSIC_COMPLETE_PHONISH;
        static const TString ACCOUNT_IS_BILLING_COMPLETE_PHONISH;
        static const TString ACCOUNT_IS_PHONISH_COMPLETION_FINISHED;
        static const TString SUBSCRIPTION_MUSIC_PREMIUM;
        static const TString ACCOUNT_DELETION_OPERATION_STARTED_AT;
        static const TString ACCOUNT_IS_CONNECT_ADMIN;
        static const TString ACCOUNT_RFC_TOTP_SECRET;
        static const TString ACCOUNT_RFC_TOTP_CHECK_TIME;
        static const TString ACCOUNT_IS_MONEY_AGREEMENT_ACCEPTED;
        static const TString ACCOUNT_ADDITIONAL_DATA_ASKED;
        static const TString ACCOUNT_ADDITIONAL_DATA_ASK_NEXT_DATETIME;
        static const TString ACCOUNT_PLUS_ENABLED;
        static const TString ACCOUNT_PLUS_TRIAL_USED_TS;
        static const TString ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS;
        static const TString ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS;
        static const TString ACCOUNT_PLUS_NEXT_CHARGE_TS;
        static const TString ACCOUNT_ENABLE_SEARCH_BY_PHONE_ALIAS;
        static const TString ACCOUNT_CREATOR_UID;
        static const TString ACCOUNT_OTT_SUBSCRIPTION;
        static const TString ACCOUNT_EXTERNAL_ORGANIZATION_IDS;
        static const TString TAKEOUT_IS_EXTRACT_IN_PROGRESS;
        static const TString TAKEOUT_ARCHIVE_URL;
        static const TString TAKEOUT_ARCHIVE_PASSWORD;
        static const TString TAKEOUT_ARCHIVE_CREATED_AT;
        static const TString TAKEOUT_FAIL_EXTRACT_AT;
        static const TString PERSON_DONT_USE_DISPLAYNAME_AS_PUBLICNAME;
        static const TString ACCOUNT_PLUS_FAMILY_ROLE;
        static const TString SUBSCRIPTION_DRIVE;
        static const TString ACCOUNT_IS_EASILY_HACKED;
        static const TString INVESTMENTS_IS_REGISTERED;
        static const TString ACCOUNT_PHONISH_NAMESPACE;
        static const TString ACCOUNT_BILLING_FEATURES;
        static const TString ACCOUNT_MAIL_OR_MESSENGER_LOGIN_ALLOWED;
        static const TString ACCOUNT_QR_CODE_LOGIN_ALLOWED;
        static const TString ACCOUNT_PUBLIC_ID_VERSION;
        static const TString TAKEOUT_SUBSCRIPTION;
        static const TString PERSON_SHOW_FIO_IN_PUBLIC_NAME;
        static const TString ACCOUNT_USER_DEFINED_PUBLIC_ID;
        static const TString ACCOUNT_SMS_CODE_LOGIN_FORBIDDEN;
        static const TString ACCOUNT_FORCE_CHALLENGE;
        static const TString ACCOUNT_HIDE_YANDEX_DOMAINS_EMAILS;
        static const TString SUBSCRIPTION_TELEMOST;
        static const TString ACCOUNT_ALLOW_WEBDAV_BY_PASSWORD;
        static const TString ACCOUNT_ALLOW_CALENDAR_BY_PASSWORD;
        static const TString ACCOUNT_PLUS_CASHBACK_ENABLED;
        static const TString PASSWORD_FORCED_CHANGING_TIME;
        static const TString ACCOUNT_IS_VERIFIED;
        static const TString SUBSCRIPTION_MAILPRO;
        static const TString SUBSCRIPTION_MAILPRO_ON;
        static const TString SUBSCRIPTION_MAILPRO_OFF;
        static const TString ACCOUNT_SMS_2FA_ON;
        static const TString ACCOUNT_FORBID_DISABLING_SMS_2FA;
        static const TString ACCOUNT_CONTENT_RATING_CLASS;
        static const TString SUBSCRIPTION_MAIL_STATUS;
        static const TString TAKEOUT_DELETE_SUBSCRIPTION;
        static const TString ACCOUNT_MUSIC_CONTENT_RATING_CLASS;
        static const TString ACCOUNT_VIDEO_CONTENT_RATING_CLASS;
        static const TString ACCOUNT_UNSUBSCRIBED_FROM_MAILLISTS;
        static const TString ACCOUNT_PERSONAL_DATA_PUBLIC_ACCESS_ALLOWED;
        static const TString ACCOUNT_PERSONAL_DATA_THIRD_PARTY_PROCESSING_ALLOWED;
        static const TString ACCOUNT_IS_CHILD;
        static const TString ACCOUNT_SCHOLAR_PASSWORD;
        static const TString PERSON_FIRSTNAME_GLOBAL;
        static const TString PERSON_LASTNAME_GLOBAL;
        static const TString PASSWORD_FORCED_CHANGING_SUSPENDED_AT;
        static const TString ACCOUNT_BANK_SUBSCRIPTION;
        static const TString ACCOUNT_PLUS_SUBSCRIPTION_LEVEL;
        static const TString ACCOUNT_PLUS_IS_FROZEN;
        static const TString ACCOUNT_FAMILY_PAY;
        static const TString ACCOUNT_IS_DOCUMENTS_AGREEMENT_ACCEPTED;
        static const TString ACCOUNT_PLUS_SUBSCRIBER_STATE;
        static const TString ACCOUNT_TOTP_YAKEY_DEVICE_IDS;
        static const TString ACCOUNT_FAMILY_CHILDREN_MANAGEMENT;

        // Synthetic attributes:
        static const TString PERSON_BIRTH_DAY;
        static const TString PERSON_BIRTH_YEAR;
        static const TString ACCOUNT_2FA_ON;
        static const TString ACCOUNT_2FA_PIN;
        static const TString ACCOUNT_HAVE_PASSWORD;
        static const TString ACCOUNT_HAVE_HINT;
        static const TString PERSON_FIO;
        static const TString ACCOUNT_NORMALIZED_LOGIN;
        static const TString ACCOUNT_IS_AVAILABLE;
        static const TString ACCOUNT_SECRET_IDS;
        static const TString ACCOUNT_HAVE_ORGANIZATION_NAME;
        static const TString ACCOUNT_PIN_LENGTH;
        static const TString ACCOUNT_PROTECTION_LEVEL;
        static const TString ACCOUNT_RFC_2FA_ON;
        static const TString ACCOUNT_HAVE_PLUS;
        static const TString ACCOUNT_KINOPOISK_OTT_SUBSCRIPTION_NAME;
        static const TString ACCOUNT_CONNECT_ORGANIZATION_IDS;
        static const TString ACCOUNT_PLUS_TRIAL_USED_TS_SYNT;
        static const TString ACCOUNT_PLUS_SUBSCRIPTION_STOPPED_TS_SYNT;
        static const TString ACCOUNT_PLUS_SUBSCRIPTION_EXPIRE_TS_SYNT;
        static const TString ACCOUNT_PLUS_NEXT_CHARGE_TS_SYNT;
        static const TString ACCOUNT_PLUS_FAMILY_ROLE_SYNT;
        static const TString ACCOUNT_SUGGEST_PUBLIC_NAME;
        static const TString ACCOUNT_HAS_CUSTOM_PUBLIC_ID;
        static const TString ACCOUNT_HAS_PLUS_CASHBACK;
        static const TString ACCOUNT_MUSIC_CONTENT_RATING_KLASS;
        static const TString ACCOUNT_VIDEO_CONTENT_RATING_KLASS;
        static const TString ACCOUNT_PLUS_MAPPED_SUBSCRIPTION_LEVEL;
        static const TString ACCOUNT_PDD_ORGANIZATION_ID;
        static const TString ACCOUNT_COMPLETION_RECOMMENDED;
        static const TString ACCOUNT_IS_KID;
        static const TString ACCOUNT_FAMILY_CHILDREN_MANAGEMENT_SYNT;

        static bool IsSynthetic(const TString& attr);
    };

    class TExtendedAttrType {
    public:
        static const TString NONE;     // "0"
        static const TString PHONE;    // "1"
        static const TString EMAIL;    // "2"
        static const TString WEBAUTHN; // "3"

        static const TString PHONE_OPERATION; // "101"
        static const TString PHONE_BINDINGS;  // "102"

        static const size_t MAX_SYN_EXTENDED_COUNT;
    };

    class TPhoneAttr {
    public:
        static const TString NUMBER;    // "1"
        static const TString CREATED;   // "2"
        static const TString BOUND;     // "3"
        static const TString CONFIRMED; // "4"
        static const TString ADMITTED;  // "5"
        static const TString SECURED;   // "6"

        static const TString FORMATTED_NUMBER;        // "101"
        static const TString E164_NUMBER;             // "102"
        static const TString MASKED_FORMATTED_NUMBER; // "103"
        static const TString MASKED_E164_NUMBER;      // "104"
        static const TString IS_CONFIRMED;            // "105"
        static const TString IS_BOUND;                // "106"
        static const TString IS_DEFAULT;              // "107"
        static const TString IS_SECURED;              // "108"
        static const TString IS_BANK;                 // "109"

        static bool IsSynthetic(const TString& attr);
    };

    class TEmailAttr {
    public:
        static const TString ADDRESS;   // "1"
        static const TString CREATED;   // "2"
        static const TString CONFIRMED; // "3"
        static const TString BOUND;     // "4"
        static const TString IS_RPOP;   // "5"
        static const TString IS_UNSAFE; // "6"
        static const TString IS_SILENT; // "7"

        static bool IsSynthetic(const TString& attr);
    };

    class TWebauthnAttr {
    public:
        static const TString EXTERNAL_ID;      // "1"
        static const TString PUBLIC_KEY;       // "2"
        static const TString SIGN_COUNT;       // "3"
        static const TString DEVICE_NAME;      // "4"
        static const TString CREATED;          // "5"
        static const TString RELYING_PARTY_ID; // "6"
        static const TString OS_FAMILY_ID;     // "7"
        static const TString BROWSER_ID;       // "8"

        static bool IsSynthetic(const TString& attr);
    };

    class TOAuthTokenAttr {
    public:
        static const TString TOKEN_ID;                    // "0"  // synthetic attr
        static const TString ACCESS_TOKEN;                // "1"
        static const TString SCOPE_IDS;                   // "2"
        static const TString UID;                         // "3"
        static const TString CLIENT_ID;                   // "4"
        static const TString DEVICE_ID;                   // "5"
        static const TString DEVICE_NAME;                 // "6"
        static const TString EXPIRES;                     // "7"
        static const TString IS_REFRESHABLE;              // "8"
        static const TString CREATED;                     // "9"
        static const TString ISSUED;                      // "10"
        static const TString META;                        // "11"
        static const TString ALIAS;                       // "12"
        static const TString COMMENT;                     // "13"
        static const TString X_TOKEN_ID;                  // "14"
        static const TString PAYMENT_AUTH_CONTEXT_ID;     // "15"
        static const TString PAYMENT_AUTH_SCOPE_ADDENDUM; // "16"
        static const TString LOGIN_ID;                    // "17"
        static const TString APP_PLATFORM;                // "18"
        static const TString IS_XTOKEN_TRUSTED;           // "19"

        static const TString IS_STATELESS; // "1001"

        static bool IsSynthetic(const TString& attr);
    };

    class TOAuthClientAttr {
    public:
        static const TString CLIENT_ID;                    // "0"  // synthetic attr
        static const TString UID;                          // "1"
        static const TString SCOPE_IDS;                    // "2"
        static const TString SECRET;                       // "3"
        static const TString OLD_SECRET;                   // "4"
        static const TString CALLBACK;                     // "5"
        static const TString APPROVAL_STATUS;              // "6"
        static const TString IS_BLOCKED;                   // "7"
        static const TString DEFAULT_TITLE;                // "8"
        static const TString TITLE_RU;                     // "9"
        static const TString TITLE_EN;                     // "10"
        static const TString TITLE_TR;                     // "11"
        static const TString GLOGOUTED;                    // "12"
        static const TString CREATED;                      // "13"
        static const TString MODIFIED;                     // "14"
        static const TString DISPLAY_ID;                   // "15"
        static const TString SERVICES;                     // "16"
        static const TString EVENTS;                       // "17"
        static const TString DEFAULT_DESCRIPTION;          // "18"
        static const TString ICON;                         // "19"
        static const TString HOMEPAGE;                     // "20"
        static const TString TITLE_UK;                     // "21"
        static const TString DESCRIPTION_RU;               // "22"
        static const TString DESCRIPTION_EN;               // "23"
        static const TString DESCRIPTION_TR;               // "24"
        static const TString DESCRIPTION_UK;               // "25"
        static const TString IS_YANDEX;                    // "26"
        static const TString ICON_ID;                      // "27"
        static const TString TELEGRAM_BOT_NAME;            // "28"
        static const TString DELETED;                      // "29"
        static const TString ALLOW_GRANTTYPE_PASSWORD;     // "30"
        static const TString REDIRECT_URIS;                // "31"
        static const TString IOS_DEFAULT_APP_ID;           // "32"
        static const TString ANDROID_DEFAULT_PACKAGE_NAME; // "33"
        static const TString ANDROID_CERT_FINGERPRINTS;    // "34"
        static const TString IOS_APPSTORE_URL;             // "35"
        static const TString ANDROID_APPSTORE_URL;         // "36"
        static const TString OWNER_UIDS;                   // "37"
        static const TString OWNER_GROUPS;                 // "38"
        static const TString OWNER_GROUP_UIDS;             // "39"
        static const TString IOS_EXTRA_APP_IDS;            // "40"
        static const TString ANDROID_EXTRA_PACKAGE_NAMES;  // "41"

        static bool IsSynthetic(const TString& attr);
    };

    class TMailStatus {
    public:
        static const TString ACTIVE; // "1"
        static const TString FROZEN; // "2"
    };
}
