#pragma once

#include "db_profile.h"

#include <util/generic/string.h>

#include <functional>
#include <map>
#include <unordered_map>
#include <vector>

class JsonTest;

namespace NPassport::NBb {
    class TDbFetcher;
    class DbFieldsRegisterer;
    class TDbFieldsResult;
    class THostsList;

    class TDbFieldsConverter: TNonCopyable {
    public:
        TDbFieldsConverter(TDbFetcher& fetcher, const THostsList& hosts, const TString& mailHostId);
        TDbFieldsConverter(TDbFetcher& fetcher, const THostsList& hosts, const TString& mailHostId, const std::vector<TString>& sids, bool forceSid2 = false);

        TDbFieldsResult* Add(const TString& value);

        TDbFetcher& Fetcher();

        void AddDbFields(const std::vector<TString>& dbfields, std::vector<TDbFieldsResult*>& results);
        void SetForceShowMailSubscription(bool value) {
            ForceShowMailSubscription_ = value;
        }

        static const TString REGNAME;
        static const TString NAROD_MAIL_LOGIN;
        static const TString REGDATE;
        static const TString LOGIN2;
        static const TString LOGIN8;
        static const TString LOGIN16;

    private:
        friend class TDbFieldsResult;
        friend class TDbFetcher;
        using TFuncType = std::function<TString(const TDbProfile*)>;
        using TComplexDbField = std::vector<std::pair<TString, TDbFieldsResult>>;
        TFuncType GetFunc(const TString& table, const TString& field, const TString& type, const TString& value) const;

        TFuncType GetAccountsFunc(const TString& field) const;
        TFuncType GetUserInfoFunc(const TString& field) const;
        TFuncType GetSubscriptionFunc(const TString& field, const TString& sid, const TString& value) const;
        TFuncType GetUserinfoSafeFunc(const TString& field) const;
        TFuncType GetPasswordQualityFunc(const TString& field) const;
        TFuncType GetUserphonesFunc(const TString& field) const;
        TFuncType GetAdtargetFunc(const TString& field) const;

        TFuncType GetSubscriptionFuncSid(const TString& field, const TString& sid) const;
        TFuncType GetSubscriptionFuncDash(const TString& field, const TString& value) const;

        TFuncType GetSubscriptionSuidFunc(const TString& sid) const;
        TFuncType GetSubscriptionLoginFunc(const TString& sid) const;
        TFuncType GetSubscriptionLoginRuleFunc(const TString& sid) const;
        TFuncType GetSubscriptionHostIdFunc(const TString& sid) const;
        TFuncType GetSubscriptionBornDateFunc(const TString& sid) const;

        TFuncType GetHostsFunc(const TString& field, const TString& sid) const;

        static TString EmptyField(const TDbProfile* profile);
        static TString ConstantField(const TDbProfile* profile, const TString& value);
        static TString SimpleField(const TDbProfile* profile, TDbIndex field);
        static TString CheckValueField(const TDbProfile* profile, TDbIndex field, const TString& val);
        static TString ConditionalUid(const TDbProfile* profile, TDbIndex condition);
        static TString SplitPairField(const TDbProfile* profile, TDbIndex field, char sep, bool first);
        static TString GalatasarayField(const TDbProfile* profile, TDbIndex alias, const TString& val);
        static TString CheckAliasPddField(const TDbProfile* profile, const TString& val);

        static bool HasMailSubscription(const TDbProfile* profile,
                                        TDbIndex mailSuid,
                                        TDbIndex mailHost,
                                        TDbIndex mailStatus,
                                        const bool ignoreFrozen);

        static const TDbProfile::TAttrs* GetPhoneAttrs(const TDbProfile* profile, const TString& phoneid);
        static TString CheckPhoneField(const TDbProfile* profile, TDbIndex phoneId, const TString& val);
        static TString PhoneTailField(const TDbProfile* profile, TDbIndex phoneId);
        static TString PhoneLoginField(const TDbProfile* profile, TDbIndex phoneNum, TDbIndex phoneId, TDbIndex normLogin);
        static TString PhoneBornDate(const TDbProfile* profile, TDbIndex phoneId);
        static TString PhoneNumberField(const TDbProfile* profile, TDbIndex phoneId);

        static TString UserDefinedLoginField(const TDbProfile* profile,
                                             TDbIndex user,
                                             TDbIndex normLogin);
        static TString MailLoginField(const TDbProfile* profile,
                                      TDbIndex mailSuid,
                                      TDbIndex mailHostId,
                                      TDbIndex mailStatus,
                                      TDbIndex mail,
                                      TDbIndex portal,
                                      TDbIndex pdd,
                                      TDbIndex alt,
                                      const bool ignoreFrozen);
        static TString NarodMailLoginField(const TDbProfile* profile,
                                           TDbIndex mailSuid,
                                           TDbIndex mailHostId,
                                           TDbIndex mailStatus,
                                           TDbIndex narod,
                                           TDbIndex mail,
                                           TDbIndex portal,
                                           const bool ignoreFrozen);
        static TString SidLoginField(const TDbProfile* profile, TDbIndex sidAttr, TDbIndex normLogin);
        static TString GalatasarayLoginField(const TDbProfile* profile, TDbIndex alias);

        static TString EnaField(const TDbProfile* profile, TDbIndex disabled);
        static TString GenderField(const TDbProfile* profile, TDbIndex index);
        static TString RegdateField(const TDbProfile* profile, TDbIndex index);
        static TString MailLoginRuleField(const TDbProfile* profile,
                                          TDbIndex mailSuid,
                                          TDbIndex mailHostId,
                                          TDbIndex mailStatus,
                                          TDbIndex attr,
                                          const bool ignoreFrozen);
        static TString MailHostIdField(const TDbProfile* profile,
                                       TDbIndex mailSuid,
                                       TDbIndex mailHostId,
                                       TDbIndex mailStatus,
                                       const TString& hostIdValue,
                                       const bool ignoreFrozen);
        static TString MailSuidField(const TDbProfile* profile,
                                     TDbIndex mailSuid,
                                     TDbIndex mailHostId,
                                     TDbIndex mailStatus,
                                     const bool ignoreFrozen);
        static TString PassportLoginRuleField(const TDbProfile* profile, TDbIndex changeReason);
        static TString LiteLoginRuleField(const TDbProfile* profile, TDbIndex liteAlias, TDbIndex portalAlias);

        static TString ComplexField(const TDbProfile* profile, const TDbFieldsResult& sid2field, const TComplexDbField& field);

        static TString HostsField(const TDbProfile* profile,
                                  const THostsList& hosts,
                                  const TString& field,
                                  const TString& sid,
                                  TDbIndex mailSuid,
                                  TDbIndex mailHostId,
                                  TDbIndex mailStatus,
                                  const TString& mailHostIdValue,
                                  const bool ignoreFrozen);

    private:
        friend class TDbFieldsRegisterer;
        friend class TBlackboxImpl;
        using TFieldName = TString;
        using TAttrName = TString;
        using TSidStr = TString;
        using TUserinfoToAttrMap = std::unordered_map<TFieldName, TAttrName>;

    public: // for tests
        using TSidsToAttrMap = std::unordered_map<TSidStr, TAttrName>;

    private: // for tests
        using TValueMapType = std::map<TFieldName, TDbFieldsResult>;

        // static mapping of dbfield -> attribute for userinfo fields
        static const TUserinfoToAttrMap& UserInfoFields();

        // static mapping of sid -> attribute for subscriptions
        // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
        static TSidsToAttrMap SUBSCRIPTIONS;

    public: // for tests
        static void InitMaps(TSidsToAttrMap&& sids);

    private: // for tests
        bool ForceSid2_ = false;
        bool ForceShowMailSubscription_ = false;

        TDbFetcher& Fetcher_;
        const THostsList& Hosts_;
        const TString MailHostId_;

        TValueMapType Values_;

        const std::vector<TString> Sids_;
    };

    class TDbFieldsResult {
    public:
        const TString& Value(const TDbProfile* profile) const;
        // private: // TODO
        friend class TDbFieldsConverter;
        //    friend class ::TJsonTest;
        TDbFieldsResult(TDbFieldsConverter::TFuncType&& func);

    private:
        mutable TString Value_;
        mutable TDbProfile const* Profile_ = nullptr;
        TDbFieldsConverter::TFuncType Func_;
    };

}
