#include "dbfields_settings.h"

#include <passport/infra/libs/cpp/utils/string/split.h>

namespace NPassport::NBb {
    TDbFieldsSettings::TDbFieldsSettings(const TString& dbfields) {
        RequireGrants_.reserve(dbfields.size() / 10 + 10);
        NUtils::Transform(
            dbfields,
            ',',
            [this](const TStringBuf buf) -> void {
                if (buf) {
                    this->RequireGrants_.insert(TString(buf));
                }
            });
    }

    bool TDbFieldsSettings::RequiresGrant(const TString& dbfield) const {
        return RequireGrants_.find(dbfield) != RequireGrants_.end();
    }
}
