#pragma once

#include "invalid_value.h"

#include <passport/infra/libs/cpp/auth_core/session_errors.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NPassport::NBb {
    class TBlackboxError: public yexception {
    public:
        enum class EType {
            Unknown = 1,
            InvalidParams = 2,
            DbException = 10,
            NoDataKeyspace = 11,
            KeyNotFound = 15,
            KeyspaceEmpty = 16,
            KeyspaceFailed = 17,
            BadSign = 18,
            AccessDenied = 21,
            __LastDeprecatedCode = 24, // do not reuse this and previous id
        };

        TBlackboxError(EType status)
            : Status_(status)
        {
        }

        EType Status() const {
            return Status_;
        }

        const TString& StatusStr() const;
        static const TString& StatusStr(EType status);

    private:
        const EType Status_;
    };

    class TDbpoolError: public TBlackboxError {
    public:
        TDbpoolError(const TStringBuf details, const TStringBuf what);
    };

    struct TExceptionInfo {
        TExceptionInfo();

        TString ToString() const;

        TBlackboxError::EType Status = TBlackboxError::EType::Unknown;
        TString Msg;
        TString ExtendedDescription;
        TString Method;
        TString Host;
        TString Hostname;
        TString CurrentTime;
    };
}
