#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NPassport::NBb {
    class TExperiment {
    public:
        static const TExperiment& Get() {
            return ins_;
        }

        static TExperiment& GetMutable() {
            return ins_;
        }

        bool IsPddPartnerTokenEnabled = true;
        bool IsHavePasswordEnabled = true;
        bool IsHaveHintEnabled = true;
        TString CookieSignMethod;
        TString TokenSignMethod;
        TString AliasSignMethod;
        TString MainAttrsSignMethod;
        TString FullAttrsSignMethod;
        size_t BadauthUseHalfIpv6AddressRate = 0;
        bool RestrictFederalUsers = false;
        size_t InvalidSessionidRate = 0;

        bool IsInHalfIpExperiment(const TString& userip) const;

        void RunCookieCheck() const {
            if (CookieSignMethod) {
                RunCheck(CookieSignMethod);
            }
        }
        void RunTokenCheck() const {
            if (TokenSignMethod) {
                RunCheck(TokenSignMethod);
            }
        }
        void RunAliasCheck() const {
            if (AliasSignMethod) {
                RunCheck(AliasSignMethod);
            }
        }
        void RunMainAttrsCheck() const {
            if (MainAttrsSignMethod) {
                RunCheck(MainAttrsSignMethod);
            }
        }
        void RunFullAttrsCheck() const {
            if (FullAttrsSignMethod) {
                RunCheck(FullAttrsSignMethod);
            }
        }

    private:
        TExperiment() = default;
        static void RunCheck(const TString& method);

        // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
        static TExperiment ins_;
    };

}
