#pragma once

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <util/generic/string.h>

#include <map>
#include <memory>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    struct THostsEntry {
        TString DbId;
        TString Prio;
    };

    class THostsList {
    public:
        THostsList(NDbPool::TDbPool& db);
        virtual ~THostsList();

        bool Find(const TString& hostId, bool pdd, THostsEntry& out) const;

        // map: "host_id" -> host entry data
        using THostsMap = std::map<TString, THostsEntry>;

    protected:
        void Run();

    private:
        std::shared_ptr<THostsMap> Load(bool pdd);

        // hosts table data
        NUtils::TSharedState<THostsMap> Hosts_;
        // domains_hosts table data
        NUtils::TSharedState<THostsMap> DomainsHosts_;

        NDbPool::TDbPool& Db_;
    };
}
