#include "invalid_value.h"

#include <passport/infra/libs/cpp/utils/string/coder.h>

namespace NPassport::NBb {
    static void PrintInvalidString(IOutputStream& o, TStringBuf value, size_t maxLen) {
        const bool isCuted = value.size() > maxLen;
        if (isCuted) {
            value.Trunc(maxLen);
        }

        bool isPrintable = std::find_if_not(value.begin(), value.end(), isprint) == value.end();
        if (isPrintable) {
            o << "'" << value;
        } else {
            o << "(base64)'" << NUtils::BinToBase64(value);
        }

        if (isCuted) {
            o << "...";
        }

        o << "'";
    }
}

template <>
IOutputStream& operator<<(IOutputStream& o, const NPassport::NBb::TInvalidValueProxy<TStringBuf>& value) {
    NPassport::NBb::PrintInvalidString(o, value.Value, value.MaxLen);
    return o;
}

template <>
IOutputStream& operator<<(IOutputStream& o, const NPassport::NBb::TInvalidValueProxy<TString>& value) {
    NPassport::NBb::PrintInvalidString(o, value.Value, value.MaxLen);
    return o;
}
